/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.snapshot.metrics;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.Metric;

public class RaftSnapshotsMetricsSource
extends AbstractMetricSource<Holder> {
    private final AtomicInteger incomingSnapshotsCounter = new AtomicInteger();
    private final AtomicInteger snapshotsLoadingMetaCounter = new AtomicInteger();
    private final AtomicInteger snapshotsWaitingCatalogCounter = new AtomicInteger();
    private final AtomicInteger snapshotsPreparingStoragesCounter = new AtomicInteger();
    private final AtomicInteger snapshotsPreparingIndexForBuildCounter = new AtomicInteger();
    private final AtomicInteger snapshotsLoadingMvDataCounter = new AtomicInteger();
    private final AtomicInteger snapshotsLoadingTxMetaCounter = new AtomicInteger();
    private final AtomicInteger outgoingSnapshotsCounter = new AtomicInteger();

    public RaftSnapshotsMetricsSource() {
        super("raft.snapshots");
    }

    protected Holder createHolder() {
        return new Holder(this.incomingSnapshotsCounter::get, this.snapshotsLoadingMetaCounter::get, this.snapshotsWaitingCatalogCounter::get, this.snapshotsPreparingStoragesCounter::get, this.snapshotsPreparingIndexForBuildCounter::get, this.snapshotsLoadingMvDataCounter::get, this.snapshotsLoadingTxMetaCounter::get, this.outgoingSnapshotsCounter::get);
    }

    public void onSnapshotInstallationStart() {
        this.incomingSnapshotsCounter.incrementAndGet();
    }

    public void onSnapshotInstallationEnd() {
        this.incomingSnapshotsCounter.decrementAndGet();
    }

    public void onLoadSnapshotMetaPhaseStart() {
        this.snapshotsLoadingMetaCounter.incrementAndGet();
    }

    public void onLoadSnapshotMetaPhaseEnd() {
        this.snapshotsLoadingMetaCounter.decrementAndGet();
    }

    public void onWaitingCatalogPhaseStart() {
        this.snapshotsWaitingCatalogCounter.incrementAndGet();
    }

    public void onWaitingCatalogPhaseEnd() {
        this.snapshotsWaitingCatalogCounter.decrementAndGet();
    }

    public void onPreparingStoragePhaseStart() {
        this.snapshotsPreparingStoragesCounter.incrementAndGet();
    }

    public void onPreparingStoragePhaseEnd() {
        this.snapshotsPreparingStoragesCounter.decrementAndGet();
    }

    public void onLoadMvDataPhaseStart() {
        this.snapshotsLoadingMvDataCounter.incrementAndGet();
    }

    public void onLoadMvDataPhaseEnd() {
        this.snapshotsLoadingMvDataCounter.decrementAndGet();
    }

    public void onLoadTxMetasPhaseStart() {
        this.snapshotsLoadingTxMetaCounter.incrementAndGet();
    }

    public void onLoadTxMetasPhaseEnd() {
        this.snapshotsLoadingTxMetaCounter.decrementAndGet();
    }

    public void onSetRowIdToBuildPhaseStart() {
        this.snapshotsPreparingIndexForBuildCounter.incrementAndGet();
    }

    public void onSetRowIdToBuildPhaseEnd() {
        this.snapshotsPreparingIndexForBuildCounter.decrementAndGet();
    }

    public void onOutgoingSnapshotStart() {
        this.outgoingSnapshotsCounter.incrementAndGet();
    }

    public void onOutgoingSnapshotEnd() {
        this.outgoingSnapshotsCounter.decrementAndGet();
    }

    public static class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final IntGauge incomingSnapshots;
        private final IntGauge snapshotsLoadingMeta;
        private final IntGauge snapshotsWaitingCatalog;
        private final IntGauge snapshotsPreparingStorages;
        private final IntGauge snapshotsPreparingIndexForBuild;
        private final IntGauge snapshotsLoadingMvData;
        private final IntGauge snapshotsLoadingTxMeta;
        private final IntGauge outgoingSnapshots;

        private Holder(IntSupplier incomingSnapshotsSupplier, IntSupplier snapshotsLoadingMetaSupplier, IntSupplier snapshotsWaitingCatalogSupplier, IntSupplier snapshotsPreparingStoragesSupplier, IntSupplier snapshotsPreparingIndexForBuildSupplier, IntSupplier snapshotsLoadingMvDataSupplier, IntSupplier snapshotsLoadingTxMetaSupplier, IntSupplier outgoingSnapshotsSupplier) {
            this.incomingSnapshots = new IntGauge("IncomingSnapshots", "Incoming Raft snapshots in progress", incomingSnapshotsSupplier);
            this.snapshotsLoadingMeta = new IntGauge("IncomingSnapshotsLoadingMeta", "Incoming Raft snapshots loading metadata", snapshotsLoadingMetaSupplier);
            this.snapshotsWaitingCatalog = new IntGauge("IncomingSnapshotsWaitingCatalog", "Incoming Raft snapshots waiting for catalog", snapshotsWaitingCatalogSupplier);
            this.snapshotsPreparingStorages = new IntGauge("IncomingSnapshotsPreparingStorages", "Incoming Raft snapshots preparing storages", snapshotsPreparingStoragesSupplier);
            this.snapshotsPreparingIndexForBuild = new IntGauge("IncomingSnapshotsPreparingIndexForBuild", "Incoming Raft snapshots preparing indexes for build", snapshotsPreparingIndexForBuildSupplier);
            this.snapshotsLoadingMvData = new IntGauge("IncomingSnapshotsLoadingMvData", "Incoming Raft snapshots loading multi-versioned data", snapshotsLoadingMvDataSupplier);
            this.snapshotsLoadingTxMeta = new IntGauge("IncomingSnapshotsLoadingTxMeta", "Incoming Raft snapshots loading transaction metadata", snapshotsLoadingTxMetaSupplier);
            this.outgoingSnapshots = new IntGauge("OutgoingSnapshots", "Outgoing Raft snapshots in progress", outgoingSnapshotsSupplier);
        }

        public Iterable<Metric> metrics() {
            return List.of(this.incomingSnapshots, this.snapshotsLoadingMeta, this.snapshotsWaitingCatalog, this.snapshotsPreparingStorages, this.snapshotsPreparingIndexForBuild, this.snapshotsLoadingMvData, this.snapshotsLoadingTxMeta, this.outgoingSnapshots);
        }
    }
}

