/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.BuildIndexReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.BuildIndexReplicaRequestBuilder;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class BuildIndexReplicaRequestDeserializer
implements MessageDeserializer<BuildIndexReplicaRequest> {
    private final BuildIndexReplicaRequestBuilder msg;

    BuildIndexReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.buildIndexReplicaRequest();
    }

    public Class<BuildIndexReplicaRequest> klass() {
        return BuildIndexReplicaRequest.class;
    }

    public BuildIndexReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.buildIndexReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Long tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistmentConsistencyToken(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                boolean tmp = reader.readBoolean("finish");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.finish(tmp);
                reader.incrementState();
            }
            case 2: {
                ReplicationGroupIdMessage tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId(tmp);
                }
                reader.incrementState();
            }
            case 3: {
                int tmp = reader.readInt("indexId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.indexId(tmp);
                reader.incrementState();
            }
            case 4: {
                List tmp = reader.readList("rowIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.rowIds(tmp);
                }
                reader.incrementState();
            }
            case 5: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readSet("abortedTransactionIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.abortedTransactionIds((Set<UUID>)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BuildIndexReplicaRequest.class);
    }
}

