/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class BinaryTupleMessageImpl
implements BinaryTupleMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 17;
    @IgniteToStringInclude
    private final int elementCount;
    @IgniteToStringInclude
    private final ByteBuffer tuple;

    private BinaryTupleMessageImpl(int elementCount, ByteBuffer tuple) {
        this.elementCount = elementCount;
        this.tuple = tuple;
    }

    @Override
    public int elementCount() {
        return this.elementCount;
    }

    @Override
    public ByteBuffer tuple() {
        return this.tuple;
    }

    public MessageSerializer serializer() {
        return BinaryTupleMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(BinaryTupleMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 17;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BinaryTupleMessageImpl otherMessage = (BinaryTupleMessageImpl)other;
        return Objects.equals(this.tuple, otherMessage.tuple) && this.elementCount == otherMessage.elementCount;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.elementCount, this.tuple);
        return result;
    }

    public BinaryTupleMessageImpl clone() {
        try {
            return (BinaryTupleMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BinaryTupleMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements BinaryTupleMessageBuilder {
        private int elementCount;
        private ByteBuffer tuple;

        private Builder() {
        }

        @Override
        public BinaryTupleMessageBuilder elementCount(int elementCount) {
            this.elementCount = elementCount;
            return this;
        }

        @Override
        public BinaryTupleMessageBuilder tuple(ByteBuffer tuple) {
            Objects.requireNonNull(tuple, "tuple is not marked @Nullable");
            this.tuple = tuple;
            return this;
        }

        @Override
        public int elementCount() {
            return this.elementCount;
        }

        @Override
        public ByteBuffer tuple() {
            return this.tuple;
        }

        @Override
        public BinaryTupleMessage build() {
            return new BinaryTupleMessageImpl(this.elementCount, Objects.requireNonNull(this.tuple, "tuple is not marked @Nullable"));
        }

        @Override
        public BinaryTupleMessage buildDeserialized() {
            return new BinaryTupleMessageImpl(this.elementCount, this.tuple);
        }
    }
}

