/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.List;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataResponse;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataResponseBuilder;

class SnapshotTxDataResponseDeserializer
implements MessageDeserializer<SnapshotTxDataResponse> {
    private final SnapshotTxDataResponseBuilder msg;

    SnapshotTxDataResponseDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotTxDataResponse();
    }

    public Class<SnapshotTxDataResponse> klass() {
        return SnapshotTxDataResponse.class;
    }

    public SnapshotTxDataResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.snapshotTxDataResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("finish");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.finish(tmp);
                reader.incrementState();
            }
            case 1: {
                List tmp = reader.readList("txIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txIds(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                List tmp = reader.readList("txMeta", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txMeta(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotTxDataResponse.class);
    }
}

