/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.raft.ResponseEntryBuilder;
import org.apache.ignite.internal.partition.replicator.network.raft.ResponseEntrySerializer;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ResponseEntryImpl
implements SnapshotMvDataResponse.ResponseEntry,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 13;
    @IgniteToStringInclude
    private final int commitPartitionId;
    @IgniteToStringInclude
    private final Integer commitTableOrZoneId;
    @IgniteToStringInclude
    private final UUID rowId;
    @IgniteToStringInclude
    private final List<BinaryRowMessage> rowVersions;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final long[] timestamps;
    @IgniteToStringInclude
    private final UUID txId;

    private ResponseEntryImpl(int commitPartitionId, Integer commitTableOrZoneId, UUID rowId, List<BinaryRowMessage> rowVersions, int tableId, long[] timestamps, UUID txId) {
        this.commitPartitionId = commitPartitionId;
        this.commitTableOrZoneId = commitTableOrZoneId;
        this.rowId = rowId;
        this.rowVersions = rowVersions;
        this.tableId = tableId;
        this.timestamps = timestamps;
        this.txId = txId;
    }

    @Override
    public int commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    public Integer commitTableOrZoneId() {
        return this.commitTableOrZoneId;
    }

    @Override
    public UUID rowId() {
        return this.rowId;
    }

    @Override
    public List<BinaryRowMessage> rowVersions() {
        return this.rowVersions;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public long[] timestamps() {
        return this.timestamps;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return ResponseEntrySerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ResponseEntryImpl.class, (Object)this);
    }

    public short messageType() {
        return 13;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResponseEntryImpl otherMessage = (ResponseEntryImpl)other;
        return Objects.equals(this.commitTableOrZoneId, otherMessage.commitTableOrZoneId) && Objects.equals(this.rowId, otherMessage.rowId) && Objects.equals(this.rowVersions, otherMessage.rowVersions) && Objects.equals(this.txId, otherMessage.txId) && Arrays.equals(this.timestamps, otherMessage.timestamps) && this.commitPartitionId == otherMessage.commitPartitionId && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commitPartitionId, this.tableId, this.commitTableOrZoneId, this.rowId, this.rowVersions, this.txId);
        result = 31 * result + Arrays.hashCode(this.timestamps);
        return result;
    }

    public ResponseEntryImpl clone() {
        try {
            return (ResponseEntryImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ResponseEntryBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rowVersions != null) {
            for (BinaryRowMessage obj : this.rowVersions) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rowVersions != null) {
            for (BinaryRowMessage obj : this.rowVersions) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements ResponseEntryBuilder {
        private int commitPartitionId;
        private Integer commitTableOrZoneId;
        private UUID rowId;
        private List<BinaryRowMessage> rowVersions;
        private int tableId;
        private long[] timestamps;
        private UUID txId;

        private Builder() {
        }

        @Override
        public ResponseEntryBuilder commitPartitionId(int commitPartitionId) {
            this.commitPartitionId = commitPartitionId;
            return this;
        }

        @Override
        public ResponseEntryBuilder commitTableOrZoneId(Integer commitTableOrZoneId) {
            this.commitTableOrZoneId = commitTableOrZoneId;
            return this;
        }

        @Override
        public ResponseEntryBuilder rowId(UUID rowId) {
            Objects.requireNonNull(rowId, "rowId is not marked @Nullable");
            this.rowId = rowId;
            return this;
        }

        @Override
        public ResponseEntryBuilder rowVersions(List<BinaryRowMessage> rowVersions) {
            Objects.requireNonNull(rowVersions, "rowVersions is not marked @Nullable");
            this.rowVersions = rowVersions;
            return this;
        }

        @Override
        public ResponseEntryBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ResponseEntryBuilder timestamps(long[] timestamps) {
            Objects.requireNonNull(timestamps, "timestamps is not marked @Nullable");
            this.timestamps = timestamps;
            return this;
        }

        @Override
        public ResponseEntryBuilder txId(UUID txId) {
            this.txId = txId;
            return this;
        }

        @Override
        public int commitPartitionId() {
            return this.commitPartitionId;
        }

        @Override
        public Integer commitTableOrZoneId() {
            return this.commitTableOrZoneId;
        }

        @Override
        public UUID rowId() {
            return this.rowId;
        }

        @Override
        public List<BinaryRowMessage> rowVersions() {
            return this.rowVersions;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public long[] timestamps() {
            return this.timestamps;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public SnapshotMvDataResponse.ResponseEntry build() {
            return new ResponseEntryImpl(this.commitPartitionId, this.commitTableOrZoneId, Objects.requireNonNull(this.rowId, "rowId is not marked @Nullable"), Objects.requireNonNull(this.rowVersions, "rowVersions is not marked @Nullable"), this.tableId, Objects.requireNonNull(this.timestamps, "timestamps is not marked @Nullable"), this.txId);
        }

        @Override
        public SnapshotMvDataResponse.ResponseEntry buildDeserialized() {
            return new ResponseEntryImpl(this.commitPartitionId, this.commitTableOrZoneId, this.rowId, this.rowVersions, this.tableId, this.timestamps, this.txId);
        }
    }
}

