/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStatesRequest;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStatesRequestBuilder;

class LocalPartitionStatesRequestDeserializer
implements MessageDeserializer<LocalPartitionStatesRequest> {
    private final LocalPartitionStatesRequestBuilder msg;

    LocalPartitionStatesRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.localPartitionStatesRequest();
    }

    public Class<LocalPartitionStatesRequest> klass() {
        return LocalPartitionStatesRequest.class;
    }

    public LocalPartitionStatesRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.localPartitionStatesRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("catalogVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.catalogVersion(tmp);
                reader.incrementState();
            }
            case 1: {
                Set tmp = reader.readSet("partitionIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.partitionIds(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Set tmp = reader.readSet("zoneIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.zoneIds(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalPartitionStatesRequest.class);
    }
}

