/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllSecondaryStorageCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllSecondaryStorageCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateAllSecondaryStorageCommandSerializer;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;
import org.apache.ignite.internal.tostring.IgniteStringifier;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tostring.SizeOnlyStringifier;

public class UpdateAllSecondaryStorageCommandImpl
implements UpdateAllSecondaryStorageCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 106;
    @IgniteToStringInclude
    private final HybridTimestamp leaseStartTime;
    @IgniteStringifier(name="rows.size", value=SizeOnlyStringifier.class)
    private final List<BinaryRowWithTombstoneMessage> rows;
    @IgniteToStringInclude
    private final int tableId;

    private UpdateAllSecondaryStorageCommandImpl(HybridTimestamp leaseStartTime, List<BinaryRowWithTombstoneMessage> rows, int tableId) {
        this.leaseStartTime = leaseStartTime;
        this.rows = rows;
        this.tableId = tableId;
    }

    @Override
    public HybridTimestamp leaseStartTime() {
        return this.leaseStartTime;
    }

    @Override
    public List<BinaryRowWithTombstoneMessage> rows() {
        return this.rows;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return UpdateAllSecondaryStorageCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(UpdateAllSecondaryStorageCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 106;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UpdateAllSecondaryStorageCommandImpl otherMessage = (UpdateAllSecondaryStorageCommandImpl)other;
        return Objects.equals(this.leaseStartTime, otherMessage.leaseStartTime) && Objects.equals(this.rows, otherMessage.rows) && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.tableId, this.leaseStartTime, this.rows);
        return result;
    }

    public UpdateAllSecondaryStorageCommandImpl clone() {
        try {
            return (UpdateAllSecondaryStorageCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UpdateAllSecondaryStorageCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rows != null) {
            for (BinaryRowWithTombstoneMessage obj : this.rows) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rows != null) {
            for (BinaryRowWithTombstoneMessage obj : this.rows) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements UpdateAllSecondaryStorageCommandBuilder {
        private HybridTimestamp leaseStartTime;
        private List<BinaryRowWithTombstoneMessage> rows;
        private int tableId;

        private Builder() {
        }

        @Override
        public UpdateAllSecondaryStorageCommandBuilder leaseStartTime(HybridTimestamp leaseStartTime) {
            Objects.requireNonNull(leaseStartTime, "leaseStartTime is not marked @Nullable");
            this.leaseStartTime = leaseStartTime;
            return this;
        }

        @Override
        public UpdateAllSecondaryStorageCommandBuilder rows(List<BinaryRowWithTombstoneMessage> rows) {
            Objects.requireNonNull(rows, "rows is not marked @Nullable");
            this.rows = rows;
            return this;
        }

        @Override
        public UpdateAllSecondaryStorageCommandBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public HybridTimestamp leaseStartTime() {
            return this.leaseStartTime;
        }

        @Override
        public List<BinaryRowWithTombstoneMessage> rows() {
            return this.rows;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public UpdateAllSecondaryStorageCommand build() {
            return new UpdateAllSecondaryStorageCommandImpl(Objects.requireNonNull(this.leaseStartTime, "leaseStartTime is not marked @Nullable"), Objects.requireNonNull(this.rows, "rows is not marked @Nullable"), this.tableId);
        }

        @Override
        public UpdateAllSecondaryStorageCommand buildDeserialized() {
            return new UpdateAllSecondaryStorageCommandImpl(this.leaseStartTime, this.rows, this.tableId);
        }
    }
}

