/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.command.TransferRowVersionsToSecondaryStorageCommand;
import org.apache.ignite.internal.partition.replicator.network.command.TransferRowVersionsToSecondaryStorageCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.TransferRowVersionsToSecondaryStorageCommandSerializer;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;
import org.apache.ignite.internal.tostring.IgniteStringifier;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tostring.SizeOnlyStringifier;

public class TransferRowVersionsToSecondaryStorageCommandImpl
implements TransferRowVersionsToSecondaryStorageCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16373;
    @IgniteToStringInclude
    private final HybridTimestamp leaseStartTime;
    @IgniteStringifier(name="rows.size", value=SizeOnlyStringifier.class)
    private final List<BinaryRowWithTombstoneMessage> rows;
    @IgniteToStringInclude
    private final int tableId;

    private TransferRowVersionsToSecondaryStorageCommandImpl(HybridTimestamp leaseStartTime, List<BinaryRowWithTombstoneMessage> rows, int tableId) {
        this.leaseStartTime = leaseStartTime;
        this.rows = rows;
        this.tableId = tableId;
    }

    @Override
    public HybridTimestamp leaseStartTime() {
        return this.leaseStartTime;
    }

    @Override
    public List<BinaryRowWithTombstoneMessage> rows() {
        return this.rows;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return TransferRowVersionsToSecondaryStorageCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(TransferRowVersionsToSecondaryStorageCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 16373;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransferRowVersionsToSecondaryStorageCommandImpl otherMessage = (TransferRowVersionsToSecondaryStorageCommandImpl)other;
        return Objects.equals(this.leaseStartTime, otherMessage.leaseStartTime) && Objects.equals(this.rows, otherMessage.rows) && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.tableId, this.leaseStartTime, this.rows);
        return result;
    }

    public TransferRowVersionsToSecondaryStorageCommandImpl clone() {
        try {
            return (TransferRowVersionsToSecondaryStorageCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TransferRowVersionsToSecondaryStorageCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rows != null) {
            for (BinaryRowWithTombstoneMessage obj : this.rows) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rows != null) {
            for (BinaryRowWithTombstoneMessage obj : this.rows) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements TransferRowVersionsToSecondaryStorageCommandBuilder {
        private HybridTimestamp leaseStartTime;
        private List<BinaryRowWithTombstoneMessage> rows;
        private int tableId;

        private Builder() {
        }

        @Override
        public TransferRowVersionsToSecondaryStorageCommandBuilder leaseStartTime(HybridTimestamp leaseStartTime) {
            Objects.requireNonNull(leaseStartTime, "leaseStartTime is not marked @Nullable");
            this.leaseStartTime = leaseStartTime;
            return this;
        }

        @Override
        public TransferRowVersionsToSecondaryStorageCommandBuilder rows(List<BinaryRowWithTombstoneMessage> rows) {
            Objects.requireNonNull(rows, "rows is not marked @Nullable");
            this.rows = rows;
            return this;
        }

        @Override
        public TransferRowVersionsToSecondaryStorageCommandBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public HybridTimestamp leaseStartTime() {
            return this.leaseStartTime;
        }

        @Override
        public List<BinaryRowWithTombstoneMessage> rows() {
            return this.rows;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public TransferRowVersionsToSecondaryStorageCommand build() {
            return new TransferRowVersionsToSecondaryStorageCommandImpl(Objects.requireNonNull(this.leaseStartTime, "leaseStartTime is not marked @Nullable"), Objects.requireNonNull(this.rows, "rows is not marked @Nullable"), this.tableId);
        }

        @Override
        public TransferRowVersionsToSecondaryStorageCommand buildDeserialized() {
            return new TransferRowVersionsToSecondaryStorageCommandImpl(this.leaseStartTime, this.rows, this.tableId);
        }
    }
}

