/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowMessage;

class TimedBinaryRowMessageDeserializer
implements MessageDeserializer<TimedBinaryRowMessage> {
    private final TimedBinaryRowMessageBuilder msg;

    TimedBinaryRowMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.timedBinaryRowMessage();
    }

    public Class<TimedBinaryRowMessage> klass() {
        return TimedBinaryRowMessage.class;
    }

    public TimedBinaryRowMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.timedBinaryRowMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (BinaryRowMessage)reader.readMessage("binaryRowMessage");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.binaryRowMessage((BinaryRowMessage)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TimedBinaryRowMessage.class);
    }
}

