/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.command.ArchiveAllCommand;
import org.apache.ignite.internal.partition.replicator.network.command.ArchiveAllCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class ArchiveAllCommandDeserializer
implements MessageDeserializer<ArchiveAllCommand> {
    private final ArchiveAllCommandBuilder msg;

    ArchiveAllCommandDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.archiveAllCommand();
    }

    public Class<ArchiveAllCommand> klass() {
        return ArchiveAllCommand.class;
    }

    public ArchiveAllCommand getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.archiveAllCommand());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ReplicationGroupIdMessage tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitPartitionId(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readBoxedLong("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.leaseStartTime((Long)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readMap("messageRowsToUpdate", MessageCollectionItemType.UUID, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.messageRowsToUpdate((Map<UUID, TimedBinaryRowMessage>)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 7: {
                UUID tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txCoordinatorId(tmp);
                }
                reader.incrementState();
            }
            case 8: {
                UUID tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ArchiveAllCommand.class);
    }
}

