/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network;

import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.UserDetailsMessage;
import org.apache.ignite.internal.partition.replicator.network.UserDetailsMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.UserDetailsMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class UserDetailsMessageImpl
implements UserDetailsMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16376;
    @IgniteToStringInclude
    private final String userName;
    @IgniteToStringInclude
    private final Set<String> userRoles;

    private UserDetailsMessageImpl(String userName, Set<String> userRoles) {
        this.userName = userName;
        this.userRoles = userRoles;
    }

    @Override
    public String userName() {
        return this.userName;
    }

    @Override
    public Set<String> userRoles() {
        return this.userRoles;
    }

    public MessageSerializer serializer() {
        return UserDetailsMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(UserDetailsMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 16376;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UserDetailsMessageImpl otherMessage = (UserDetailsMessageImpl)other;
        return Objects.equals(this.userName, otherMessage.userName) && Objects.equals(this.userRoles, otherMessage.userRoles);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.userName, this.userRoles);
        return result;
    }

    public UserDetailsMessageImpl clone() {
        try {
            return (UserDetailsMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UserDetailsMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements UserDetailsMessageBuilder {
        private String userName;
        private Set<String> userRoles;

        private Builder() {
        }

        @Override
        public UserDetailsMessageBuilder userName(String userName) {
            Objects.requireNonNull(userName, "userName is not marked @Nullable");
            this.userName = userName;
            return this;
        }

        @Override
        public UserDetailsMessageBuilder userRoles(Set<String> userRoles) {
            Objects.requireNonNull(userRoles, "userRoles is not marked @Nullable");
            this.userRoles = userRoles;
            return this;
        }

        @Override
        public String userName() {
            return this.userName;
        }

        @Override
        public Set<String> userRoles() {
            return this.userRoles;
        }

        @Override
        public UserDetailsMessage build() {
            return new UserDetailsMessageImpl(Objects.requireNonNull(this.userName, "userName is not marked @Nullable"), Objects.requireNonNull(this.userRoles, "userRoles is not marked @Nullable"));
        }

        @Override
        public UserDetailsMessage buildDeserialized() {
            return new UserDetailsMessageImpl(this.userName, this.userRoles);
        }
    }
}

