/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMeta;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaResponse;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaResponseBuilder;

class SnapshotMetaResponseDeserializer
implements MessageDeserializer<SnapshotMetaResponse> {
    private final SnapshotMetaResponseBuilder msg;

    SnapshotMetaResponseDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotMetaResponse();
    }

    public Class<SnapshotMetaResponse> klass() {
        return SnapshotMetaResponse.class;
    }

    public SnapshotMetaResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.snapshotMetaResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                PartitionSnapshotMeta tmp = (PartitionSnapshotMeta)reader.readMessage("meta");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.meta(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotMetaResponse.class);
    }
}

