/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateMinimumActiveTxBeginTimeCommand;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateMinimumActiveTxBeginTimeCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.UpdateMinimumActiveTxBeginTimeCommandSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class UpdateMinimumActiveTxBeginTimeCommandImpl
implements UpdateMinimumActiveTxBeginTimeCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 45;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final long timestamp;

    private UpdateMinimumActiveTxBeginTimeCommandImpl(HybridTimestamp initiatorTime, HybridTimestamp safeTime, long timestamp) {
        this.initiatorTime = initiatorTime;
        this.safeTime = safeTime;
        this.timestamp = timestamp;
    }

    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return UpdateMinimumActiveTxBeginTimeCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(UpdateMinimumActiveTxBeginTimeCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 45;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UpdateMinimumActiveTxBeginTimeCommandImpl otherMessage = (UpdateMinimumActiveTxBeginTimeCommandImpl)other;
        return Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime) && this.timestamp == otherMessage.timestamp;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.timestamp, this.initiatorTime, this.safeTime);
        return result;
    }

    public UpdateMinimumActiveTxBeginTimeCommandImpl clone() {
        try {
            return (UpdateMinimumActiveTxBeginTimeCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static UpdateMinimumActiveTxBeginTimeCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements UpdateMinimumActiveTxBeginTimeCommandBuilder {
        private HybridTimestamp initiatorTime;
        private HybridTimestamp safeTime;
        private long timestamp;

        private Builder() {
        }

        @Override
        public UpdateMinimumActiveTxBeginTimeCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public UpdateMinimumActiveTxBeginTimeCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public UpdateMinimumActiveTxBeginTimeCommandBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public UpdateMinimumActiveTxBeginTimeCommand build() {
            return new UpdateMinimumActiveTxBeginTimeCommandImpl(Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.safeTime, this.timestamp);
        }

        @Override
        public UpdateMinimumActiveTxBeginTimeCommand buildDeserialized() {
            return new UpdateMinimumActiveTxBeginTimeCommandImpl(this.initiatorTime, this.safeTime, this.timestamp);
        }
    }
}

