/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandV2;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandV2Impl;

class FinishTxCommandV2Serializer
implements MessageSerializer<FinishTxCommandV2> {
    public static final FinishTxCommandV2Serializer INSTANCE = new FinishTxCommandV2Serializer();

    private FinishTxCommandV2Serializer() {
    }

    public boolean writeMessage(FinishTxCommandV2 msg, MessageWriter writer) throws MessageMappingException {
        FinishTxCommandV2Impl message = (FinishTxCommandV2Impl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.finishTxCommandV2());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)7)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("commit", message.commit());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeHybridTimestamp("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBoolean("full", message.full());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeHybridTimestamp("initiatorTime", message.initiatorTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeList("partitions", message.partitions(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeHybridTimestamp("safeTime", message.safeTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

