/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandV2;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandV2Builder;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessage;

class FinishTxCommandV2Deserializer
implements MessageDeserializer<FinishTxCommandV2> {
    private final FinishTxCommandV2Builder msg;

    FinishTxCommandV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.finishTxCommandV2();
    }

    public Class<FinishTxCommandV2> klass() {
        return FinishTxCommandV2.class;
    }

    public FinishTxCommandV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.finishTxCommandV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commit(tmp);
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitTimestamp(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readList("partitions", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.partitions((List<EnlistedPartitionGroupMessage>)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.safeTime((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FinishTxCommandV2.class);
    }
}

