/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommandV3;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommandV3Builder;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommandV3Serializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class BuildIndexCommandV3Impl
implements BuildIndexCommandV3,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 51;
    @IgniteToStringInclude
    private final Set<UUID> abortedTransactionIds;
    @IgniteToStringInclude
    private final boolean finish;
    @IgniteToStringInclude
    private final int indexId;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private final List<UUID> rowIds;
    @IgniteToStringInclude
    private final int tableId;

    private BuildIndexCommandV3Impl(Set<UUID> abortedTransactionIds, boolean finish, int indexId, int requiredCatalogVersion, List<UUID> rowIds, int tableId) {
        this.abortedTransactionIds = abortedTransactionIds;
        this.finish = finish;
        this.indexId = indexId;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.rowIds = rowIds;
        this.tableId = tableId;
    }

    @Override
    public Set<UUID> abortedTransactionIds() {
        return this.abortedTransactionIds;
    }

    @Override
    public boolean finish() {
        return this.finish;
    }

    @Override
    public int indexId() {
        return this.indexId;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    @Override
    public List<UUID> rowIds() {
        return this.rowIds;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return BuildIndexCommandV3Serializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(BuildIndexCommandV3Impl.class, (Object)this);
    }

    public short messageType() {
        return 51;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BuildIndexCommandV3Impl otherMessage = (BuildIndexCommandV3Impl)other;
        return Objects.equals(this.abortedTransactionIds, otherMessage.abortedTransactionIds) && Objects.equals(this.rowIds, otherMessage.rowIds) && this.finish == otherMessage.finish && this.indexId == otherMessage.indexId && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.finish, this.indexId, this.requiredCatalogVersion, this.tableId, this.abortedTransactionIds, this.rowIds);
        return result;
    }

    public BuildIndexCommandV3Impl clone() {
        try {
            return (BuildIndexCommandV3Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BuildIndexCommandV3Builder builder() {
        return new Builder();
    }

    private static class Builder
    implements BuildIndexCommandV3Builder {
        private Set<UUID> abortedTransactionIds;
        private boolean finish;
        private int indexId;
        private int requiredCatalogVersion;
        private List<UUID> rowIds;
        private int tableId;

        private Builder() {
        }

        @Override
        public BuildIndexCommandV3Builder abortedTransactionIds(Set<UUID> abortedTransactionIds) {
            Objects.requireNonNull(abortedTransactionIds, "abortedTransactionIds is not marked @Nullable");
            this.abortedTransactionIds = abortedTransactionIds;
            return this;
        }

        @Override
        public BuildIndexCommandV3Builder finish(boolean finish) {
            this.finish = finish;
            return this;
        }

        @Override
        public BuildIndexCommandV3Builder indexId(int indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public BuildIndexCommandV3Builder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public BuildIndexCommandV3Builder rowIds(List<UUID> rowIds) {
            Objects.requireNonNull(rowIds, "rowIds is not marked @Nullable");
            this.rowIds = rowIds;
            return this;
        }

        @Override
        public BuildIndexCommandV3Builder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public Set<UUID> abortedTransactionIds() {
            return this.abortedTransactionIds;
        }

        @Override
        public boolean finish() {
            return this.finish;
        }

        @Override
        public int indexId() {
            return this.indexId;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public List<UUID> rowIds() {
            return this.rowIds;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public BuildIndexCommandV3 build() {
            return new BuildIndexCommandV3Impl(Objects.requireNonNull(this.abortedTransactionIds, "abortedTransactionIds is not marked @Nullable"), this.finish, this.indexId, this.requiredCatalogVersion, Objects.requireNonNull(this.rowIds, "rowIds is not marked @Nullable"), this.tableId);
        }

        @Override
        public BuildIndexCommandV3 buildDeserialized() {
            return new BuildIndexCommandV3Impl(this.abortedTransactionIds, this.finish, this.indexId, this.requiredCatalogVersion, this.rowIds, this.tableId);
        }
    }
}

