/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommandV3;
import org.apache.ignite.internal.partition.replicator.network.command.BuildIndexCommandV3Builder;

class BuildIndexCommandV3Deserializer
implements MessageDeserializer<BuildIndexCommandV3> {
    private final BuildIndexCommandV3Builder msg;

    BuildIndexCommandV3Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.buildIndexCommandV3();
    }

    public Class<BuildIndexCommandV3> klass() {
        return BuildIndexCommandV3.class;
    }

    public BuildIndexCommandV3 getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.buildIndexCommandV3());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Set tmp = reader.readSet("abortedTransactionIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.abortedTransactionIds(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readBoolean("finish");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.finish(tmp != 0);
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("indexId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.indexId(tmp);
                reader.incrementState();
            }
            case 3: {
                List tmp = reader.readList("rowIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.rowIds(tmp);
                }
                reader.incrementState();
            }
            case 4: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BuildIndexCommandV3.class);
    }
}

