/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultipleRowsSecondaryReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultipleRowsSecondaryReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultipleRowsSecondaryReplicaRequestSerializer;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteStringifier;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tostring.SizeOnlyStringifier;

public class ReadWriteMultipleRowsSecondaryReplicaRequestImpl
implements ReadWriteMultipleRowsSecondaryReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 104;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final RequestType requestType;
    @IgniteStringifier(name="rows.size", value=SizeOnlyStringifier.class)
    private final List<BinaryRowWithTombstoneMessage> rows;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private ReadWriteMultipleRowsSecondaryReplicaRequestImpl(Long enlistmentConsistencyToken, ReplicationGroupIdMessage groupId, RequestType requestType, List<BinaryRowWithTombstoneMessage> rows, int tableId, HybridTimestamp timestamp) {
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.groupId = groupId;
        this.requestType = requestType;
        this.rows = rows;
        this.tableId = tableId;
        this.timestamp = timestamp;
    }

    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public RequestType requestType() {
        return this.requestType;
    }

    @Override
    public List<BinaryRowWithTombstoneMessage> rows() {
        return this.rows;
    }

    public int tableId() {
        return this.tableId;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return ReadWriteMultipleRowsSecondaryReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadWriteMultipleRowsSecondaryReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 104;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadWriteMultipleRowsSecondaryReplicaRequestImpl otherMessage = (ReadWriteMultipleRowsSecondaryReplicaRequestImpl)other;
        return Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals((Object)this.requestType, (Object)otherMessage.requestType) && Objects.equals(this.rows, otherMessage.rows) && Objects.equals(this.timestamp, otherMessage.timestamp) && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.tableId, this.enlistmentConsistencyToken, this.groupId, this.requestType, this.rows, this.timestamp});
        return result;
    }

    public ReadWriteMultipleRowsSecondaryReplicaRequestImpl clone() {
        try {
            return (ReadWriteMultipleRowsSecondaryReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadWriteMultipleRowsSecondaryReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
        if (this.rows != null) {
            for (BinaryRowWithTombstoneMessage obj : this.rows) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
        if (this.rows != null) {
            for (BinaryRowWithTombstoneMessage obj : this.rows) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements ReadWriteMultipleRowsSecondaryReplicaRequestBuilder {
        private Long enlistmentConsistencyToken;
        private ReplicationGroupIdMessage groupId;
        private RequestType requestType;
        private List<BinaryRowWithTombstoneMessage> rows;
        private int tableId;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public ReadWriteMultipleRowsSecondaryReplicaRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public ReadWriteMultipleRowsSecondaryReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadWriteMultipleRowsSecondaryReplicaRequestBuilder requestType(RequestType requestType) {
            Objects.requireNonNull(requestType, "requestType is not marked @Nullable");
            this.requestType = requestType;
            return this;
        }

        @Override
        public ReadWriteMultipleRowsSecondaryReplicaRequestBuilder rows(List<BinaryRowWithTombstoneMessage> rows) {
            Objects.requireNonNull(rows, "rows is not marked @Nullable");
            this.rows = rows;
            return this;
        }

        @Override
        public ReadWriteMultipleRowsSecondaryReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadWriteMultipleRowsSecondaryReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public RequestType requestType() {
            return this.requestType;
        }

        @Override
        public List<BinaryRowWithTombstoneMessage> rows() {
            return this.rows;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public ReadWriteMultipleRowsSecondaryReplicaRequest build() {
            return new ReadWriteMultipleRowsSecondaryReplicaRequestImpl(Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.requestType, "requestType is not marked @Nullable"), Objects.requireNonNull(this.rows, "rows is not marked @Nullable"), this.tableId, this.timestamp);
        }

        @Override
        public ReadWriteMultipleRowsSecondaryReplicaRequest buildDeserialized() {
            return new ReadWriteMultipleRowsSecondaryReplicaRequestImpl(this.enlistmentConsistencyToken, this.groupId, this.requestType, this.rows, this.tableId, this.timestamp);
        }
    }
}

