/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessageImpl;

class BinaryRowWithTombstoneMessageSerializer
implements MessageSerializer<BinaryRowWithTombstoneMessage> {
    public static final BinaryRowWithTombstoneMessageSerializer INSTANCE = new BinaryRowWithTombstoneMessageSerializer();

    private BinaryRowWithTombstoneMessageSerializer() {
    }

    public boolean writeMessage(BinaryRowWithTombstoneMessage msg, MessageWriter writer) throws MessageMappingException {
        BinaryRowWithTombstoneMessageImpl message = (BinaryRowWithTombstoneMessageImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.binaryRowWithTombstoneMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)5)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteBuffer("binaryTuple", message.binaryTuple());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeUuid("rowId", message.rowId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeBoolean("tombstone", message.tombstone());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

