/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.snapshot;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionMvStorageAccess;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionTxStateAccess;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.SnapshotUri;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.incoming.IncomingSnapshotCopier;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.OutgoingSnapshotReader;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.OutgoingSnapshotsManager;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotCopier;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.jetbrains.annotations.Nullable;

public class PartitionSnapshotStorage {
    private static final IgniteLogger LOG = Loggers.forClass(PartitionSnapshotStorage.class);
    private static final int DEFAULT_WAIT_FOR_METADATA_CATCHUP_MS = 3000;
    private final PartitionKey partitionKey;
    private final TopologyService topologyService;
    private final OutgoingSnapshotsManager outgoingSnapshotsManager;
    private final Int2ObjectMap<PartitionMvStorageAccess> partitionsByTableId = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private final Map<UUID, CompletableFuture<Void>> ongoingSnapshotOperations = new HashMap<UUID, CompletableFuture<Void>>();
    private final Object snapshotOperationLock = new Object();
    private final PartitionTxStateAccess txState;
    private final CatalogService catalogService;
    private final FailureProcessor failureProcessor;
    private final Executor incomingSnapshotsExecutor;
    private final long waitForMetadataCatchupMs;

    public PartitionSnapshotStorage(PartitionKey partitionKey, TopologyService topologyService, OutgoingSnapshotsManager outgoingSnapshotsManager, PartitionTxStateAccess txState, CatalogService catalogService, FailureProcessor failureProcessor, Executor incomingSnapshotsExecutor) {
        this(partitionKey, topologyService, outgoingSnapshotsManager, txState, catalogService, failureProcessor, incomingSnapshotsExecutor, 3000L);
    }

    public PartitionSnapshotStorage(PartitionKey partitionKey, TopologyService topologyService, OutgoingSnapshotsManager outgoingSnapshotsManager, PartitionTxStateAccess txState, CatalogService catalogService, FailureProcessor failureProcessor, Executor incomingSnapshotsExecutor, long waitForMetadataCatchupMs) {
        this.partitionKey = partitionKey;
        this.topologyService = topologyService;
        this.outgoingSnapshotsManager = outgoingSnapshotsManager;
        this.txState = txState;
        this.catalogService = catalogService;
        this.failureProcessor = failureProcessor;
        this.incomingSnapshotsExecutor = incomingSnapshotsExecutor;
        this.waitForMetadataCatchupMs = waitForMetadataCatchupMs;
    }

    public PartitionKey partitionKey() {
        return this.partitionKey;
    }

    public TopologyService topologyService() {
        return this.topologyService;
    }

    public MessagingService messagingService() {
        return this.outgoingSnapshotsManager.messagingService();
    }

    public OutgoingSnapshotsManager outgoingSnapshotsManager() {
        return this.outgoingSnapshotsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Int2ObjectMap<PartitionMvStorageAccess> partitionsByTableId() {
        Int2ObjectMap<PartitionMvStorageAccess> int2ObjectMap = this.partitionsByTableId;
        synchronized (int2ObjectMap) {
            return new Int2ObjectOpenHashMap(this.partitionsByTableId);
        }
    }

    public void addMvPartition(int tableId, PartitionMvStorageAccess partition) {
        PartitionMvStorageAccess prev = (PartitionMvStorageAccess)this.partitionsByTableId.put(tableId, (Object)partition);
        assert (prev == null) : this.partitionKey + ": partition storage for table ID " + tableId + " already exists.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> removeMvPartition(int tableId) {
        Object object = this.snapshotOperationLock;
        synchronized (object) {
            if (this.ongoingSnapshotOperations.isEmpty()) {
                this.partitionsByTableId.remove(tableId);
                return CompletableFutures.nullCompletedFuture();
            }
            return CompletableFutures.allOf(this.ongoingSnapshotOperations.values()).thenCompose(v -> this.removeMvPartition(tableId));
        }
    }

    public PartitionTxStateAccess txState() {
        return this.txState;
    }

    public CatalogService catalogService() {
        return this.catalogService;
    }

    public FailureProcessor failureProcessor() {
        return this.failureProcessor;
    }

    public SnapshotCopier startIncomingSnapshot(String uri) {
        final UUID snapshotId = UUID.randomUUID();
        LOG.info("Starting incoming snapshot [partitionKey={}, uri={}, snapshotId={}]", new Object[]{this.partitionKey, uri, snapshotId});
        this.startSnapshotOperation(snapshotId);
        SnapshotUri snapshotUri = SnapshotUri.fromStringUri(uri);
        IncomingSnapshotCopier copier = new IncomingSnapshotCopier(this, snapshotUri, this.incomingSnapshotsExecutor, this.waitForMetadataCatchupMs){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    PartitionSnapshotStorage.this.completeSnapshotOperation(snapshotId);
                }
            }
        };
        copier.start();
        return copier;
    }

    public SnapshotReader startOutgoingSnapshot() {
        final UUID snapshotId = UUID.randomUUID();
        LOG.info("Starting outgoing snapshot [partitionKey={}, snapshotId={}]", new Object[]{this.partitionKey, snapshotId});
        this.startSnapshotOperation(snapshotId);
        return new OutgoingSnapshotReader(snapshotId, this){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    PartitionSnapshotStorage.this.completeSnapshotOperation(snapshotId);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSnapshotOperation(UUID snapshotId) {
        Object object = this.snapshotOperationLock;
        synchronized (object) {
            CompletableFuture previousFuture = this.ongoingSnapshotOperations.put(snapshotId, new CompletableFuture());
            assert (previousFuture == null) : String.format("Snapshot already in progress [partitionId=%s, snapshotId=%s]", this.partitionKey, snapshotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeSnapshotOperation(UUID snapshotId) {
        Object object = this.snapshotOperationLock;
        synchronized (object) {
            CompletableFuture<Void> operationFuture = this.ongoingSnapshotOperations.remove(snapshotId);
            assert (operationFuture != null) : String.format("No snapshot in progress [partitionId=%s, snapshotId=%s]", this.partitionKey, snapshotId);
            operationFuture.complete(null);
        }
    }

    @Nullable
    public RaftOutter.SnapshotMeta readStartupSnapshotMeta() {
        PartitionMvStorageAccess storageWithMinLastAppliedIndex = null;
        long minLastAppliedIndex = Long.MAX_VALUE;
        for (PartitionMvStorageAccess partitionStorage : this.partitionsByTableId.values()) {
            long lastAppliedIndex = partitionStorage.lastAppliedIndex();
            assert (lastAppliedIndex >= 0L) : String.format("Partition storage [tableId=%d, partitionId=%d] contains an unexpected applied index value: %d.", partitionStorage.tableId(), partitionStorage.partitionId(), lastAppliedIndex);
            if (lastAppliedIndex == 0L) {
                return null;
            }
            if (lastAppliedIndex >= minLastAppliedIndex) continue;
            minLastAppliedIndex = lastAppliedIndex;
            storageWithMinLastAppliedIndex = partitionStorage;
        }
        if (this.txState.lastAppliedIndex() < minLastAppliedIndex) {
            return this.startupSnapshotMetaFromTxStorage();
        }
        assert (storageWithMinLastAppliedIndex != null);
        return this.startupSnapshotMetaFromPartitionStorage(storageWithMinLastAppliedIndex);
    }

    @Nullable
    private RaftOutter.SnapshotMeta startupSnapshotMetaFromTxStorage() {
        long lastAppliedIndex = this.txState.lastAppliedIndex();
        if (lastAppliedIndex == 0L) {
            return null;
        }
        RaftGroupConfiguration configuration = this.txState.committedGroupConfiguration();
        assert (configuration != null) : this.partitionKey + ": empty configuration in startup snapshot.";
        return PartitionSnapshotStorage.startupSnapshotMeta(lastAppliedIndex, this.txState.lastAppliedTerm(), configuration);
    }

    private RaftOutter.SnapshotMeta startupSnapshotMetaFromPartitionStorage(PartitionMvStorageAccess partitionStorage) {
        RaftGroupConfiguration configuration = partitionStorage.committedGroupConfiguration();
        assert (configuration != null) : this.partitionKey + ": empty configuration in startup snapshot.";
        return PartitionSnapshotStorage.startupSnapshotMeta(partitionStorage.lastAppliedIndex(), partitionStorage.lastAppliedTerm(), configuration);
    }

    private static RaftOutter.SnapshotMeta startupSnapshotMeta(long lastAppliedIndex, long lastAppliedTerm, RaftGroupConfiguration configuration) {
        return new RaftMessagesFactory().snapshotMeta().lastIncludedIndex(lastAppliedIndex).lastIncludedTerm(lastAppliedTerm).cfgIndex(configuration.index()).cfgTerm(configuration.term()).peersList((Collection)configuration.peers()).oldPeersList((Collection)configuration.oldPeers()).learnersList((Collection)configuration.learners()).oldLearnersList((Collection)configuration.oldLearners()).build();
    }
}

