/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowPkReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class ReadWriteSingleRowPkReplicaRequestDeserializer
implements MessageDeserializer<ReadWriteSingleRowPkReplicaRequest> {
    private final ReadWriteSingleRowPkReplicaRequestBuilder msg;

    ReadWriteSingleRowPkReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readWriteSingleRowPkReplicaRequest();
    }

    public Class<ReadWriteSingleRowPkReplicaRequest> klass() {
        return ReadWriteSingleRowPkReplicaRequest.class;
    }

    public ReadWriteSingleRowPkReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readWriteSingleRowPkReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<UUID> tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitPartitionId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Comparable<UUID> tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.coordinatorId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Comparable<UUID> tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistmentConsistencyToken((Long)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 4: {
                ByteBuffer tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                ByteBuffer tmp = reader.readByteBuffer("primaryKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.primaryKey(tmp);
                }
                reader.incrementState();
            }
            case 6: {
                RequestType tmp;
                int shiftedId = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType requestType = tmp = shiftedId == 0 ? null : RequestType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.requestType(tmp);
                }
                reader.incrementState();
            }
            case 7: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 8: {
                int tmp = reader.readBoolean("skipDelayedAck") ? 1 : 0;
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.skipDelayedAck(tmp != 0);
                reader.incrementState();
            }
            case 9: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 10: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 11: {
                Object tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transactionId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadWriteSingleRowPkReplicaRequest.class);
    }
}

