/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.replication.BuildIndexReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.BuildIndexReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.BuildIndexReplicaRequestSerializer;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class BuildIndexReplicaRequestImpl
implements BuildIndexReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 21;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final boolean finish;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final int indexId;
    @IgniteToStringInclude
    private final List<UUID> rowIds;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final Set<UUID> abortedTransactionIds;

    private BuildIndexReplicaRequestImpl(Long enlistmentConsistencyToken, boolean finish, ReplicationGroupIdMessage groupId, int indexId, List<UUID> rowIds, int tableId, HybridTimestamp timestamp, Set<UUID> abortedTransactionIds) {
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.finish = finish;
        this.groupId = groupId;
        this.indexId = indexId;
        this.rowIds = rowIds;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.abortedTransactionIds = abortedTransactionIds;
    }

    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    @Override
    public boolean finish() {
        return this.finish;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public int indexId() {
        return this.indexId;
    }

    @Override
    public List<UUID> rowIds() {
        return this.rowIds;
    }

    public int tableId() {
        return this.tableId;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public Set<UUID> abortedTransactionIds() {
        return this.abortedTransactionIds;
    }

    public MessageSerializer serializer() {
        return BuildIndexReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(BuildIndexReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 21;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BuildIndexReplicaRequestImpl otherMessage = (BuildIndexReplicaRequestImpl)other;
        return Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.rowIds, otherMessage.rowIds) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.abortedTransactionIds, otherMessage.abortedTransactionIds) && this.finish == otherMessage.finish && this.indexId == otherMessage.indexId && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.finish, this.indexId, this.tableId, this.enlistmentConsistencyToken, this.groupId, this.rowIds, this.timestamp, this.abortedTransactionIds);
        return result;
    }

    public BuildIndexReplicaRequestImpl clone() {
        try {
            return (BuildIndexReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BuildIndexReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements BuildIndexReplicaRequestBuilder {
        private Long enlistmentConsistencyToken;
        private boolean finish;
        private ReplicationGroupIdMessage groupId;
        private int indexId;
        private List<UUID> rowIds;
        private int tableId;
        private HybridTimestamp timestamp;
        private Set<UUID> abortedTransactionIds;

        private Builder() {
        }

        @Override
        public BuildIndexReplicaRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public BuildIndexReplicaRequestBuilder finish(boolean finish) {
            this.finish = finish;
            return this;
        }

        @Override
        public BuildIndexReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public BuildIndexReplicaRequestBuilder indexId(int indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public BuildIndexReplicaRequestBuilder rowIds(List<UUID> rowIds) {
            Objects.requireNonNull(rowIds, "rowIds is not marked @Nullable");
            this.rowIds = rowIds;
            return this;
        }

        @Override
        public BuildIndexReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public BuildIndexReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public BuildIndexReplicaRequestBuilder abortedTransactionIds(Set<UUID> abortedTransactionIds) {
            Objects.requireNonNull(abortedTransactionIds, "abortedTransactionIds is not marked @Nullable");
            this.abortedTransactionIds = abortedTransactionIds;
            return this;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public boolean finish() {
            return this.finish;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public int indexId() {
            return this.indexId;
        }

        @Override
        public List<UUID> rowIds() {
            return this.rowIds;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public Set<UUID> abortedTransactionIds() {
            return this.abortedTransactionIds;
        }

        @Override
        public BuildIndexReplicaRequest build() {
            return new BuildIndexReplicaRequestImpl(Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), this.finish, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.indexId, Objects.requireNonNull(this.rowIds, "rowIds is not marked @Nullable"), this.tableId, this.timestamp, Objects.requireNonNull(this.abortedTransactionIds, "abortedTransactionIds is not marked @Nullable"));
        }

        @Override
        public BuildIndexReplicaRequest buildDeserialized() {
            return new BuildIndexReplicaRequestImpl(this.enlistmentConsistencyToken, this.finish, this.groupId, this.indexId, this.rowIds, this.tableId, this.timestamp, this.abortedTransactionIds);
        }
    }
}

