/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessageBuilder;

class BinaryTupleMessageDeserializer
implements MessageDeserializer<BinaryTupleMessage> {
    private final BinaryTupleMessageBuilder msg;

    BinaryTupleMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.binaryTupleMessage();
    }

    public Class<BinaryTupleMessage> klass() {
        return BinaryTupleMessage.class;
    }

    public BinaryTupleMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.binaryTupleMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("elementCount");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.elementCount(tmp);
                reader.incrementState();
            }
            case 1: {
                ByteBuffer tmp = reader.readByteBuffer("tuple");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.tuple(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BinaryTupleMessage.class);
    }
}

