/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaRequestSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class SnapshotMetaRequestImpl
implements SnapshotMetaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 10;
    @IgniteToStringInclude
    private final UUID id;

    private SnapshotMetaRequestImpl(UUID id) {
        this.id = id;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    public MessageSerializer serializer() {
        return SnapshotMetaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(SnapshotMetaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 10;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SnapshotMetaRequestImpl otherMessage = (SnapshotMetaRequestImpl)other;
        return Objects.equals(this.id, otherMessage.id);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.id);
        return result;
    }

    public SnapshotMetaRequestImpl clone() {
        try {
            return (SnapshotMetaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SnapshotMetaRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SnapshotMetaRequestBuilder {
        private UUID id;

        private Builder() {
        }

        @Override
        public SnapshotMetaRequestBuilder id(UUID id) {
            Objects.requireNonNull(id, "id is not marked @Nullable");
            this.id = id;
            return this;
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public SnapshotMetaRequest build() {
            return new SnapshotMetaRequestImpl(Objects.requireNonNull(this.id, "id is not marked @Nullable"));
        }

        @Override
        public SnapshotMetaRequest buildDeserialized() {
            return new SnapshotMetaRequestImpl(this.id);
        }
    }
}

