/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.message;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.message.HasDataRequest;
import org.apache.ignite.internal.partition.replicator.network.message.HasDataRequestBuilder;

class HasDataRequestDeserializer
implements MessageDeserializer<HasDataRequest> {
    private final HasDataRequestBuilder msg;

    HasDataRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.hasDataRequest();
    }

    public Class<HasDataRequest> klass() {
        return HasDataRequest.class;
    }

    public HasDataRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.hasDataRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("partitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitionId(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HasDataRequest.class);
    }
}

