/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import java.util.Map;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateMessageBuilder;

class LocalTablePartitionStateMessageDeserializer
implements MessageDeserializer<LocalTablePartitionStateMessage> {
    private final LocalTablePartitionStateMessageBuilder msg;

    LocalTablePartitionStateMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.localTablePartitionStateMessage();
    }

    public Class<LocalTablePartitionStateMessage> klass() {
        return LocalTablePartitionStateMessage.class;
    }

    public LocalTablePartitionStateMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.localTablePartitionStateMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Map tmp = reader.readMap("tablePartitionIdToEstimatedRowsMap", MessageCollectionItemType.MSG, MessageCollectionItemType.LONG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.tablePartitionIdToEstimatedRowsMap(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LocalTablePartitionStateMessage.class);
    }
}

