/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.UserDetailsMessage;
import org.apache.ignite.internal.partition.replicator.network.UserDetailsMessageImpl;

class UserDetailsMessageSerializer
implements MessageSerializer<UserDetailsMessage> {
    public static final UserDetailsMessageSerializer INSTANCE = new UserDetailsMessageSerializer();

    private UserDetailsMessageSerializer() {
    }

    public boolean writeMessage(UserDetailsMessage msg, MessageWriter writer) throws MessageMappingException {
        UserDetailsMessageImpl message = (UserDetailsMessageImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.userDetailsMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("userName", message.userName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeSet("userRoles", message.userRoles(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

