/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSwapRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSwapRowReplicaRequestImpl;

class ReadWriteSwapRowReplicaRequestSerializer
implements MessageSerializer<ReadWriteSwapRowReplicaRequest> {
    public static final ReadWriteSwapRowReplicaRequestSerializer INSTANCE = new ReadWriteSwapRowReplicaRequestSerializer();

    private ReadWriteSwapRowReplicaRequestSerializer() {
    }

    public boolean writeMessage(ReadWriteSwapRowReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadWriteSwapRowReplicaRequestImpl message = (ReadWriteSwapRowReplicaRequestImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readWriteSwapRowReplicaRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)13)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("commitPartitionId", (NetworkMessage)message.commitPartitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("coordinatorId", message.coordinatorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBoxedLong("enlistmentConsistencyToken", message.enlistmentConsistencyToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeBoolean("full", message.full());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeMessage("groupId", (NetworkMessage)message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeByteBuffer("newBinaryTuple", message.newBinaryTuple());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeByteBuffer("oldBinaryTuple", message.oldBinaryTuple());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                int idShifted = message.requestType() == null ? 0 : message.requestType().id() + 1;
                boolean written = writer.writeInt("requestType", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                boolean written = writer.writeBoolean("skipDelayedAck", message.skipDelayedAck());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                boolean written = writer.writeUuid("transactionId", message.transactionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

