/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequestSerializer;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ReadOnlyDirectSingleRowReplicaRequestImpl
implements ReadOnlyDirectSingleRowReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 22;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final ByteBuffer primaryKey;
    @IgniteToStringInclude
    private final RequestType requestType;
    @IgniteToStringInclude
    private final int schemaVersion;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private ReadOnlyDirectSingleRowReplicaRequestImpl(Long enlistmentConsistencyToken, ReplicationGroupIdMessage groupId, ByteBuffer primaryKey, RequestType requestType, int schemaVersion, int tableId, HybridTimestamp timestamp) {
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.groupId = groupId;
        this.primaryKey = primaryKey;
        this.requestType = requestType;
        this.schemaVersion = schemaVersion;
        this.tableId = tableId;
        this.timestamp = timestamp;
    }

    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public ByteBuffer primaryKey() {
        return this.primaryKey;
    }

    @Override
    public RequestType requestType() {
        return this.requestType;
    }

    public int schemaVersion() {
        return this.schemaVersion;
    }

    public int tableId() {
        return this.tableId;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return ReadOnlyDirectSingleRowReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadOnlyDirectSingleRowReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 22;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadOnlyDirectSingleRowReplicaRequestImpl otherMessage = (ReadOnlyDirectSingleRowReplicaRequestImpl)other;
        return Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.primaryKey, otherMessage.primaryKey) && Objects.equals((Object)this.requestType, (Object)otherMessage.requestType) && Objects.equals(this.timestamp, otherMessage.timestamp) && this.schemaVersion == otherMessage.schemaVersion && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.schemaVersion, this.tableId, this.enlistmentConsistencyToken, this.groupId, this.primaryKey, this.requestType, this.timestamp});
        return result;
    }

    public ReadOnlyDirectSingleRowReplicaRequestImpl clone() {
        try {
            return (ReadOnlyDirectSingleRowReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadOnlyDirectSingleRowReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadOnlyDirectSingleRowReplicaRequestBuilder {
        private Long enlistmentConsistencyToken;
        private ReplicationGroupIdMessage groupId;
        private ByteBuffer primaryKey;
        private RequestType requestType;
        private int schemaVersion;
        private int tableId;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequestBuilder primaryKey(ByteBuffer primaryKey) {
            Objects.requireNonNull(primaryKey, "primaryKey is not marked @Nullable");
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequestBuilder requestType(RequestType requestType) {
            Objects.requireNonNull(requestType, "requestType is not marked @Nullable");
            this.requestType = requestType;
            return this;
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequestBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public ByteBuffer primaryKey() {
            return this.primaryKey;
        }

        @Override
        public RequestType requestType() {
            return this.requestType;
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequest build() {
            return new ReadOnlyDirectSingleRowReplicaRequestImpl(Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.primaryKey, "primaryKey is not marked @Nullable"), Objects.requireNonNull(this.requestType, "requestType is not marked @Nullable"), this.schemaVersion, this.tableId, this.timestamp);
        }

        @Override
        public ReadOnlyDirectSingleRowReplicaRequest buildDeserialized() {
            return new ReadOnlyDirectSingleRowReplicaRequestImpl(this.enlistmentConsistencyToken, this.groupId, this.primaryKey, this.requestType, this.schemaVersion, this.tableId, this.timestamp);
        }
    }
}

