/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessageBuilder;

class BinaryRowWithTombstoneMessageDeserializer
implements MessageDeserializer<BinaryRowWithTombstoneMessage> {
    private final BinaryRowWithTombstoneMessageBuilder msg;

    BinaryRowWithTombstoneMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.binaryRowWithTombstoneMessage();
    }

    public Class<BinaryRowWithTombstoneMessage> klass() {
        return BinaryRowWithTombstoneMessage.class;
    }

    public BinaryRowWithTombstoneMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.binaryRowWithTombstoneMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer byteBuffer = reader.readByteBuffer("binaryTuple");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (byteBuffer != null) {
                    this.msg.binaryTuple(byteBuffer);
                }
                reader.incrementState();
            }
            case 1: {
                long l = reader.readLong("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp(l);
                reader.incrementState();
            }
            case 2: {
                UUID uUID = reader.readUuid("rowId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (uUID != null) {
                    this.msg.rowId(uUID);
                }
                reader.incrementState();
            }
            case 3: {
                int n = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(n);
                reader.incrementState();
            }
            case 4: {
                boolean bl = reader.readBoolean("tombstone");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tombstone(bl);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BinaryRowWithTombstoneMessage.class);
    }
}

