/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateRequest;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateRequestImpl;

class LocalTablePartitionStateRequestSerializer
implements MessageSerializer<LocalTablePartitionStateRequest> {
    public static final LocalTablePartitionStateRequestSerializer INSTANCE = new LocalTablePartitionStateRequestSerializer();

    private LocalTablePartitionStateRequestSerializer() {
    }

    public boolean writeMessage(LocalTablePartitionStateRequest msg, MessageWriter writer) throws MessageMappingException {
        LocalTablePartitionStateRequestImpl message = (LocalTablePartitionStateRequestImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.localTablePartitionStateRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("catalogVersion", message.catalogVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeSet("zonePartitionIds", message.zonePartitionIds(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

