/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.util.List;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultipleRowsSecondaryReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultipleRowsSecondaryReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class ReadWriteMultipleRowsSecondaryReplicaRequestDeserializer
implements MessageDeserializer<ReadWriteMultipleRowsSecondaryReplicaRequest> {
    private final ReadWriteMultipleRowsSecondaryReplicaRequestBuilder msg;

    ReadWriteMultipleRowsSecondaryReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readWriteMultipleRowsSecondaryReplicaRequest();
    }

    public Class<ReadWriteMultipleRowsSecondaryReplicaRequest> klass() {
        return ReadWriteMultipleRowsSecondaryReplicaRequest.class;
    }

    public ReadWriteMultipleRowsSecondaryReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readWriteMultipleRowsSecondaryReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Long tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistmentConsistencyToken(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Long tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                RequestType tmp;
                int shiftedId = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType requestType = tmp = shiftedId == 0 ? null : RequestType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.requestType(tmp);
                }
                reader.incrementState();
            }
            case 3: {
                List tmp = reader.readList("rows", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.rows(tmp);
                }
                reader.incrementState();
            }
            case 4: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 5: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadWriteMultipleRowsSecondaryReplicaRequest.class);
    }
}

