/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequestImpl;

class ReadOnlySingleRowPkReplicaRequestSerializer
implements MessageSerializer<ReadOnlySingleRowPkReplicaRequest> {
    public static final ReadOnlySingleRowPkReplicaRequestSerializer INSTANCE = new ReadOnlySingleRowPkReplicaRequestSerializer();

    private ReadOnlySingleRowPkReplicaRequestSerializer() {
    }

    public boolean writeMessage(ReadOnlySingleRowPkReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadOnlySingleRowPkReplicaRequestImpl message = (ReadOnlySingleRowPkReplicaRequestImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readOnlySingleRowPkReplicaRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)10)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeUuid("coordinatorId", message.coordinatorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("groupId", (NetworkMessage)message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeByteBuffer("primaryKey", message.primaryKey());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeHybridTimestamp("readTimestamp", message.readTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                int idShifted = message.requestType() == null ? 0 : message.requestType().id() + 1;
                boolean written = writer.writeInt("requestType", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeUuid("transactionId", message.transactionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                boolean written = writer.writeBoolean("usePrimary", message.usePrimary());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

