/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalTablePartitionStateMessageSerializer;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class LocalTablePartitionStateMessageImpl
implements LocalTablePartitionStateMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 108;
    @IgniteToStringInclude
    private final Map<TablePartitionIdMessage, Long> tablePartitionIdToEstimatedRowsMap;

    private LocalTablePartitionStateMessageImpl(Map<TablePartitionIdMessage, Long> tablePartitionIdToEstimatedRowsMap) {
        this.tablePartitionIdToEstimatedRowsMap = tablePartitionIdToEstimatedRowsMap;
    }

    @Override
    public Map<TablePartitionIdMessage, Long> tablePartitionIdToEstimatedRowsMap() {
        return this.tablePartitionIdToEstimatedRowsMap;
    }

    public MessageSerializer serializer() {
        return LocalTablePartitionStateMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(LocalTablePartitionStateMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 108;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LocalTablePartitionStateMessageImpl otherMessage = (LocalTablePartitionStateMessageImpl)other;
        return Objects.equals(this.tablePartitionIdToEstimatedRowsMap, otherMessage.tablePartitionIdToEstimatedRowsMap);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.tablePartitionIdToEstimatedRowsMap);
        return result;
    }

    public LocalTablePartitionStateMessageImpl clone() {
        try {
            return (LocalTablePartitionStateMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static LocalTablePartitionStateMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.tablePartitionIdToEstimatedRowsMap != null) {
            Set<Map.Entry<TablePartitionIdMessage, Long>> tablePartitionIdToEstimatedRowsMapEntrySet = this.tablePartitionIdToEstimatedRowsMap.entrySet();
            for (Map.Entry<TablePartitionIdMessage, Long> entry : tablePartitionIdToEstimatedRowsMapEntrySet) {
                TablePartitionIdMessage key = entry.getKey();
                Long value = entry.getValue();
                if (key == null) continue;
                key.prepareMarshal(usedDescriptors, (Object)marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.tablePartitionIdToEstimatedRowsMap != null) {
            Set<Map.Entry<TablePartitionIdMessage, Long>> tablePartitionIdToEstimatedRowsMapEntrySet = this.tablePartitionIdToEstimatedRowsMap.entrySet();
            for (Map.Entry<TablePartitionIdMessage, Long> entry : tablePartitionIdToEstimatedRowsMapEntrySet) {
                TablePartitionIdMessage key = entry.getKey();
                Long value = entry.getValue();
                if (key == null) continue;
                key.unmarshal((Object)marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements LocalTablePartitionStateMessageBuilder {
        private Map<TablePartitionIdMessage, Long> tablePartitionIdToEstimatedRowsMap;

        private Builder() {
        }

        @Override
        public LocalTablePartitionStateMessageBuilder tablePartitionIdToEstimatedRowsMap(Map<TablePartitionIdMessage, Long> tablePartitionIdToEstimatedRowsMap) {
            Objects.requireNonNull(tablePartitionIdToEstimatedRowsMap, "tablePartitionIdToEstimatedRowsMap is not marked @Nullable");
            this.tablePartitionIdToEstimatedRowsMap = tablePartitionIdToEstimatedRowsMap;
            return this;
        }

        @Override
        public Map<TablePartitionIdMessage, Long> tablePartitionIdToEstimatedRowsMap() {
            return this.tablePartitionIdToEstimatedRowsMap;
        }

        @Override
        public LocalTablePartitionStateMessage build() {
            return new LocalTablePartitionStateMessageImpl(Objects.requireNonNull(this.tablePartitionIdToEstimatedRowsMap, "tablePartitionIdToEstimatedRowsMap is not marked @Nullable"));
        }

        @Override
        public LocalTablePartitionStateMessage buildDeserialized() {
            return new LocalTablePartitionStateMessageImpl(this.tablePartitionIdToEstimatedRowsMap);
        }
    }
}

