/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.UserDetailsMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequestV2;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequestV2Builder;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequestV2Serializer;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ReadOnlySingleRowPkReplicaRequestV2Impl
implements ReadOnlySingleRowPkReplicaRequestV2,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 30;
    @IgniteToStringInclude
    private final UUID coordinatorId;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final ByteBuffer primaryKey;
    @IgniteToStringInclude
    private final HybridTimestamp readTimestamp;
    @IgniteToStringInclude
    private final RequestType requestType;
    @IgniteToStringInclude
    private final int schemaVersion;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID transactionId;
    @IgniteToStringInclude
    private final boolean usePrimary;
    @IgniteToStringInclude
    private final UserDetailsMessage userDetails;

    private ReadOnlySingleRowPkReplicaRequestV2Impl(UUID coordinatorId, ReplicationGroupIdMessage groupId, ByteBuffer primaryKey, HybridTimestamp readTimestamp, RequestType requestType, int schemaVersion, int tableId, HybridTimestamp timestamp, UUID transactionId, boolean usePrimary, UserDetailsMessage userDetails) {
        this.coordinatorId = coordinatorId;
        this.groupId = groupId;
        this.primaryKey = primaryKey;
        this.readTimestamp = readTimestamp;
        this.requestType = requestType;
        this.schemaVersion = schemaVersion;
        this.tableId = tableId;
        this.timestamp = timestamp;
        this.transactionId = transactionId;
        this.usePrimary = usePrimary;
        this.userDetails = userDetails;
    }

    @Override
    public UUID coordinatorId() {
        return this.coordinatorId;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public ByteBuffer primaryKey() {
        return this.primaryKey;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public RequestType requestType() {
        return this.requestType;
    }

    public int schemaVersion() {
        return this.schemaVersion;
    }

    public int tableId() {
        return this.tableId;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID transactionId() {
        return this.transactionId;
    }

    @Override
    public boolean usePrimary() {
        return this.usePrimary;
    }

    @Override
    public UserDetailsMessage userDetails() {
        return this.userDetails;
    }

    public MessageSerializer serializer() {
        return ReadOnlySingleRowPkReplicaRequestV2Serializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(ReadOnlySingleRowPkReplicaRequestV2Impl.class, (Object)this);
    }

    public short messageType() {
        return 30;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ReadOnlySingleRowPkReplicaRequestV2Impl otherMessage = (ReadOnlySingleRowPkReplicaRequestV2Impl)other;
        return Objects.equals(this.coordinatorId, otherMessage.coordinatorId) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.primaryKey, otherMessage.primaryKey) && Objects.equals(this.readTimestamp, otherMessage.readTimestamp) && Objects.equals((Object)this.requestType, (Object)otherMessage.requestType) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.transactionId, otherMessage.transactionId) && Objects.equals(this.userDetails, otherMessage.userDetails) && this.schemaVersion == otherMessage.schemaVersion && this.tableId == otherMessage.tableId && this.usePrimary == otherMessage.usePrimary;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.schemaVersion, this.tableId, this.usePrimary, this.coordinatorId, this.groupId, this.primaryKey, this.readTimestamp, this.requestType, this.timestamp, this.transactionId, this.userDetails});
        return result;
    }

    public ReadOnlySingleRowPkReplicaRequestV2Impl clone() {
        try {
            return (ReadOnlySingleRowPkReplicaRequestV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ReadOnlySingleRowPkReplicaRequestV2Builder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
        if (this.userDetails != null) {
            this.userDetails.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
        if (this.userDetails != null) {
            this.userDetails.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ReadOnlySingleRowPkReplicaRequestV2Builder {
        private UUID coordinatorId;
        private ReplicationGroupIdMessage groupId;
        private ByteBuffer primaryKey;
        private HybridTimestamp readTimestamp;
        private RequestType requestType;
        private int schemaVersion;
        private int tableId;
        private HybridTimestamp timestamp;
        private UUID transactionId;
        private boolean usePrimary;
        private UserDetailsMessage userDetails;

        private Builder() {
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder coordinatorId(UUID coordinatorId) {
            this.coordinatorId = coordinatorId;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder primaryKey(ByteBuffer primaryKey) {
            Objects.requireNonNull(primaryKey, "primaryKey is not marked @Nullable");
            this.primaryKey = primaryKey;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder readTimestamp(HybridTimestamp readTimestamp) {
            Objects.requireNonNull(readTimestamp, "readTimestamp is not marked @Nullable");
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder requestType(RequestType requestType) {
            Objects.requireNonNull(requestType, "requestType is not marked @Nullable");
            this.requestType = requestType;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder transactionId(UUID transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder usePrimary(boolean usePrimary) {
            this.usePrimary = usePrimary;
            return this;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2Builder userDetails(UserDetailsMessage userDetails) {
            this.userDetails = userDetails;
            return this;
        }

        @Override
        public UUID coordinatorId() {
            return this.coordinatorId;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public ByteBuffer primaryKey() {
            return this.primaryKey;
        }

        @Override
        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        @Override
        public RequestType requestType() {
            return this.requestType;
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID transactionId() {
            return this.transactionId;
        }

        @Override
        public boolean usePrimary() {
            return this.usePrimary;
        }

        @Override
        public UserDetailsMessage userDetails() {
            return this.userDetails;
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2 build() {
            return new ReadOnlySingleRowPkReplicaRequestV2Impl(this.coordinatorId, Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.primaryKey, "primaryKey is not marked @Nullable"), Objects.requireNonNull(this.readTimestamp, "readTimestamp is not marked @Nullable"), Objects.requireNonNull(this.requestType, "requestType is not marked @Nullable"), this.schemaVersion, this.tableId, this.timestamp, this.transactionId, this.usePrimary, this.userDetails);
        }

        @Override
        public ReadOnlySingleRowPkReplicaRequestV2 buildDeserialized() {
            return new ReadOnlySingleRowPkReplicaRequestV2Impl(this.coordinatorId, this.groupId, this.primaryKey, this.readTimestamp, this.requestType, this.schemaVersion, this.tableId, this.timestamp, this.transactionId, this.usePrimary, this.userDetails);
        }
    }
}

