/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlySingleRowPkReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class ReadOnlySingleRowPkReplicaRequestDeserializer
implements MessageDeserializer<ReadOnlySingleRowPkReplicaRequest> {
    private final ReadOnlySingleRowPkReplicaRequestBuilder msg;

    ReadOnlySingleRowPkReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readOnlySingleRowPkReplicaRequest();
    }

    public Class<ReadOnlySingleRowPkReplicaRequest> klass() {
        return ReadOnlySingleRowPkReplicaRequest.class;
    }

    public ReadOnlySingleRowPkReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readOnlySingleRowPkReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<UUID> tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.coordinatorId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Comparable<UUID> tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Comparable<UUID> tmp = reader.readByteBuffer("primaryKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.primaryKey((ByteBuffer)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Comparable<UUID> tmp = reader.readHybridTimestamp("readTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.readTimestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                RequestType tmp;
                int shiftedId = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType requestType = tmp = shiftedId == 0 ? null : RequestType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.requestType(tmp);
                }
                reader.incrementState();
            }
            case 5: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 6: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 8: {
                Object tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transactionId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 9: {
                boolean tmp = reader.readBoolean("usePrimary");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.usePrimary(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadOnlySingleRowPkReplicaRequest.class);
    }
}

