/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowVersionMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowVersionMessageBuilder;

class BinaryRowVersionMessageDeserializer
implements MessageDeserializer<BinaryRowVersionMessage> {
    private final BinaryRowVersionMessageBuilder msg;

    BinaryRowVersionMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.binaryRowVersionMessage();
    }

    public Class<BinaryRowVersionMessage> klass() {
        return BinaryRowVersionMessage.class;
    }

    public BinaryRowVersionMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.binaryRowVersionMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer byteBuffer = reader.readByteBuffer("binaryTuple");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (byteBuffer != null) {
                    this.msg.binaryTuple(byteBuffer);
                }
                reader.incrementState();
            }
            case 1: {
                boolean bl = reader.readBoolean("isArchived");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.isArchived(bl);
                reader.incrementState();
            }
            case 2: {
                int n = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(n);
                reader.incrementState();
            }
            case 3: {
                boolean bl = reader.readBoolean("tombstone");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tombstone(bl);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BinaryRowVersionMessage.class);
    }
}

