/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.message;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.message.HasDataResponse;
import org.apache.ignite.internal.partition.replicator.network.message.HasDataResponseBuilder;

class HasDataResponseDeserializer
implements MessageDeserializer<HasDataResponse> {
    private final HasDataResponseBuilder msg;

    HasDataResponseDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.hasDataResponse();
    }

    public Class<HasDataResponse> klass() {
        return HasDataResponse.class;
    }

    public HasDataResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.hasDataResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("presenceString");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.presenceString(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HasDataResponse.class);
    }
}

