/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.DistributionAlgorithm;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FairPartitionDistributionAlgorithm
implements DistributionAlgorithm {
    @Override
    public List<Set<Assignment>> assignPartitions(Collection<String> nodes, List<Set<Assignment>> currentDistribution, int partitions, int replicaFactor, int consensusGroupSize) {
        assert (consensusGroupSize <= replicaFactor) : "consensusGroupSize should be less or equal to replicaFactor";
        if (nodes.isEmpty()) {
            return FairPartitionDistributionAlgorithm.emptyAssignment(partitions);
        }
        ArrayList<String> dataNodes = new ArrayList<String>(nodes);
        dataNodes.sort(null);
        List<NodeReplicas> assignments = FairPartitionDistributionAlgorithm.mapNodesToReplicas(currentDistribution, dataNodes);
        this.assignReplicas(dataNodes, assignments, partitions, replicaFactor, consensusGroupSize, true);
        this.assignReplicas(dataNodes, assignments, partitions, replicaFactor, replicaFactor - consensusGroupSize, false);
        return FairPartitionDistributionAlgorithm.nodeReplicasToAssignments(assignments, partitions);
    }

    private void assignReplicas(List<String> dataNodes, List<NodeReplicas> assignments, int partitions, int replicaFactor, int replicaGroupSize, boolean consensusGroup) {
        int rf = Math.min(consensusGroup ? replicaGroupSize : replicaFactor, dataNodes.size());
        int idealMin = partitions * rf / dataNodes.size();
        int idealMax = partitions * rf % dataNodes.size() == 0 ? idealMin : idealMin + 1;
        FairPartitionDistributionAlgorithm.adjustConsensusSize(assignments, replicaGroupSize, consensusGroup);
        FairPartitionDistributionAlgorithm.assignOrphanReplicas(partitions, assignments, rf, consensusGroup);
        FairPartitionDistributionAlgorithm.rebalance(assignments, idealMax, idealMin, consensusGroup);
    }

    private static void adjustConsensusSize(List<NodeReplicas> assignments, int replicaGroupSize, boolean consensusGroup) {
        if (!consensusGroup) {
            return;
        }
        Map<Integer, List<NodeReplica>> replicasByPartitionId = assignments.stream().flatMap(nr -> nr.replicas.stream().map(r -> new NodeReplica(nr.nodeName, (Replica)r))).collect(Collectors.groupingBy(nr -> nr.replica.partitionId));
        for (List<NodeReplica> r : replicasByPartitionId.values()) {
            Map<Boolean, List<NodeReplica>> byConsensus = r.stream().collect(Collectors.groupingBy(nr -> nr.replica.isConsensusReplica));
            List peers = byConsensus.get(true) == null ? List.of() : byConsensus.get(true);
            List learners = byConsensus.get(false) == null ? List.of() : byConsensus.get(false);
            ArrayList<NodeReplica> flipConsensus = new ArrayList<NodeReplica>();
            if (peers.size() < replicaGroupSize && !learners.isEmpty()) {
                int i = 0;
                for (int promoteSize = Math.min(learners.size(), replicaGroupSize - peers.size()); promoteSize > 0; --promoteSize) {
                    flipConsensus.add((NodeReplica)learners.get(i));
                    ++i;
                }
            }
            for (NodeReplica flip : flipConsensus) {
                for (NodeReplicas nr2 : assignments) {
                    if (!nr2.nodeName.equals(flip.nodeName)) continue;
                    nr2.flipConsensus(flip.replica.partitionId);
                }
            }
        }
    }

    private static List<Set<Assignment>> emptyAssignment(int partitions) {
        ArrayList<Set<Assignment>> assignment = new ArrayList<Set<Assignment>>(partitions);
        for (int i = 0; i < partitions; ++i) {
            assignment.add(Collections.emptySet());
        }
        return assignment;
    }

    private static int nextOne(int current, int max) {
        return current < max ? current + 1 : 0;
    }

    private static void assignOrphanReplicas(int partitions, List<NodeReplicas> assignments, int replicas, boolean consensusGroup) {
        List<Integer> orphanReplicas = FairPartitionDistributionAlgorithm.findOrphanPartitionReplicas(partitions, assignments, replicas);
        int replicaToAddPartition = 0;
        for (int orphanReplica : orphanReplicas) {
            boolean added = false;
            for (int n = 0; n < assignments.size(); ++n) {
                NodeReplicas nr = assignments.get(replicaToAddPartition);
                replicaToAddPartition = FairPartitionDistributionAlgorithm.nextOne(replicaToAddPartition, assignments.size() - 1);
                if (!nr.add(orphanReplica, consensusGroup)) continue;
                added = true;
                break;
            }
            assert (added);
        }
        int totalReplicas = 0;
        for (NodeReplicas nr : assignments) {
            totalReplicas += nr.size();
        }
        assert (totalReplicas == partitions * replicas);
    }

    private static List<Integer> findOrphanPartitionReplicas(int partitions, List<NodeReplicas> nodeReplicas, int replicas) {
        ArrayList<Integer> orphanReplicas = new ArrayList<Integer>();
        for (int p = 0; p < partitions; ++p) {
            int r = 0;
            for (NodeReplicas nr : nodeReplicas) {
                if (!nr.contains(p) || ++r <= replicas) continue;
                nr.remove(p);
            }
            for (int i = r; i < replicas; ++i) {
                orphanReplicas.add(p);
            }
        }
        return orphanReplicas;
    }

    private static void rebalance(List<NodeReplicas> nodeReplicas, int idealMax, int idealMin, boolean consensusGroup) {
        Collections.sort(nodeReplicas);
        int overloadedPtr = nodeReplicas.size() - 1;
        for (int underloadedRightBorder = 0; nodeReplicas.get(underloadedRightBorder).size() < idealMax && underloadedRightBorder < nodeReplicas.size() - 1; ++underloadedRightBorder) {
        }
        while (overloadedPtr > 0) {
            NodeReplicas onr = nodeReplicas.get(overloadedPtr);
            while (onr.size() > idealMax) {
                boolean added = false;
                for (int i = 0; i < nodeReplicas.size(); ++i) {
                    NodeReplicas unr = nodeReplicas.get(i);
                    if (unr.size() > idealMin) continue;
                    for (Replica r : onr.replicas) {
                        if (r.isConsensusReplica != consensusGroup || !unr.add(r.partitionId, r.isConsensusReplica)) continue;
                        onr.remove(r);
                        added = true;
                        break;
                    }
                    if (added) break;
                }
                if (consensusGroup) {
                    assert (added) : IgniteStringFormatter.format((String)"Failed to add consensus replica [overloadedNode={}, nodes={}].", (Object[])new Object[]{onr, nodeReplicas});
                    continue;
                }
                if (added) continue;
                NodeReplicas unr = FairPartitionDistributionAlgorithm.findUnderloadedNode(nodeReplicas, idealMin);
                FairPartitionDistributionAlgorithm.exchangeReplicasOnLackOfLearners(onr, unr);
            }
            --overloadedPtr;
        }
        Collections.sort(nodeReplicas);
        int underloadedPtr = 0;
        for (int overloadedLeftBorder = nodeReplicas.size() - 1; nodeReplicas.get(overloadedLeftBorder).size() > idealMin && overloadedLeftBorder > 0; --overloadedLeftBorder) {
        }
        while (underloadedPtr < nodeReplicas.size() - 1) {
            NodeReplicas unr = nodeReplicas.get(underloadedPtr);
            while (unr.size() < idealMin) {
                boolean added = false;
                for (int i = nodeReplicas.size() - 1; i >= 0; --i) {
                    NodeReplicas onr = nodeReplicas.get(i);
                    if (onr.size() == idealMin) continue;
                    for (Replica r : onr.replicas) {
                        if (r.isConsensusReplica != consensusGroup || !unr.add(r.partitionId, r.isConsensusReplica)) continue;
                        onr.remove(r);
                        added = true;
                        break;
                    }
                    if (added) break;
                }
                if (consensusGroup) {
                    assert (added) : IgniteStringFormatter.format((String)"Failed to add consensus replica [underloadedNode={}, nodes={}].", (Object[])new Object[]{unr, nodeReplicas});
                    continue;
                }
                if (added) continue;
                NodeReplicas onr = FairPartitionDistributionAlgorithm.findOverloadedNode(nodeReplicas, idealMin);
                FairPartitionDistributionAlgorithm.exchangeReplicasOnLackOfLearners(onr, unr);
            }
            ++underloadedPtr;
        }
    }

    private static void exchangeReplicasOnLackOfLearners(NodeReplicas overloadedNode, NodeReplicas underloadedNode) {
        int n = FairPartitionDistributionAlgorithm.findPartitionIdOfReplicaToMove(overloadedNode, underloadedNode);
        Replica x = FairPartitionDistributionAlgorithm.findReplicaToSwap(overloadedNode, underloadedNode);
        FairPartitionDistributionAlgorithm.swapReplicas(overloadedNode, underloadedNode, n, x.partitionId);
    }

    private static NodeReplicas findUnderloadedNode(List<NodeReplicas> nodeReplicas, int idealMin) {
        for (NodeReplicas unr : nodeReplicas) {
            if (unr.size() > idealMin) continue;
            return unr;
        }
        throw new AssertionError((Object)("No underloaded node found [nodes=" + nodeReplicas + ", idealMin=" + idealMin + "]."));
    }

    private static NodeReplicas findOverloadedNode(List<NodeReplicas> nodeReplicas, int idealMin) {
        for (int i = nodeReplicas.size() - 1; i >= 0; --i) {
            NodeReplicas onr = nodeReplicas.get(i);
            if (onr.size() == idealMin) continue;
            return onr;
        }
        throw new AssertionError((Object)("No overloaded node found [nodes=" + nodeReplicas + ", idealMin=" + idealMin + "]."));
    }

    private static Replica findReplicaToSwap(NodeReplicas overloadedNode, NodeReplicas underloadedNode) {
        for (Replica x : overloadedNode.replicas) {
            if (!underloadedNode.replicas.stream().noneMatch(r -> r.partitionId == x.partitionId)) continue;
            return x;
        }
        throw new AssertionError((Object)("No X replica to swap found [overloadedNode=" + overloadedNode + ", underloadedNode=" + underloadedNode + "]."));
    }

    private static void swapReplicas(NodeReplicas overloadedNode, NodeReplicas underloadedNode, int n, int x) {
        overloadedNode.remove(x);
        assert (underloadedNode.add(x, true));
        underloadedNode.remove(n);
        overloadedNode.remove(n);
        assert (underloadedNode.add(n, false)) : "Failed to add learner [node=" + underloadedNode + ", partitionId=" + n + "].";
        assert (overloadedNode.add(n, true)) : "Failed to add consensus replica [node=" + overloadedNode + ", partitionId=" + n + "].";
    }

    private static int findPartitionIdOfReplicaToMove(NodeReplicas overloadedNode, NodeReplicas underloadedNode) {
        for (Replica ro : overloadedNode.replicas) {
            if (ro.isConsensusReplica) continue;
            for (Replica ru : underloadedNode.replicas) {
                if (ru.partitionId != ro.partitionId || !ru.isConsensusReplica) continue;
                return ro.partitionId;
            }
        }
        throw new AssertionError((Object)("No learner to move found [overloadedNode=" + overloadedNode + ", underloadedNode=" + underloadedNode + "]."));
    }

    private static List<NodeReplicas> mapNodesToReplicas(List<Set<Assignment>> previousAssignments, List<String> dataNodes) {
        ArrayList<NodeReplicas> res = new ArrayList<NodeReplicas>();
        HashMap<String, NodeReplicas> replicasByNode = new HashMap<String, NodeReplicas>();
        for (String node : dataNodes) {
            NodeReplicas nr = new NodeReplicas(node);
            res.add(nr);
            replicasByNode.put(node, nr);
        }
        for (int partition = 0; partition < previousAssignments.size(); ++partition) {
            Set<Assignment> partitionNodes = previousAssignments.get(partition);
            for (Assignment node : partitionNodes) {
                NodeReplicas nr = (NodeReplicas)replicasByNode.get(node.consistentId());
                if (nr == null) continue;
                assert (!nr.contains(partition, node.isPeer()));
                nr.add(partition, node.isPeer());
            }
        }
        return res;
    }

    private static List<Set<Assignment>> nodeReplicasToAssignments(List<NodeReplicas> nodeReplicas, int partitions) {
        ArrayList<Set<Assignment>> partitionAssignments = new ArrayList<Set<Assignment>>();
        for (int p = 0; p < partitions; ++p) {
            partitionAssignments.add(new HashSet());
        }
        for (NodeReplicas nr : nodeReplicas) {
            for (Replica r : nr.replicas) {
                ((Set)partitionAssignments.get(r.partitionId)).add(FairPartitionDistributionAlgorithm.assignment(nr.nodeName, r.isConsensusReplica));
            }
        }
        return partitionAssignments;
    }

    private static Assignment assignment(String consistentId, boolean isPeer) {
        return isPeer ? Assignment.forPeer(consistentId) : Assignment.forLearner(consistentId);
    }

    private static class NodeReplica {
        final String nodeName;
        final Replica replica;

        NodeReplica(String nodeName, Replica replica) {
            this.nodeName = nodeName;
            this.replica = replica;
        }
    }

    private static class NodeReplicas
    implements Comparable<NodeReplicas> {
        @IgniteToStringInclude
        final String nodeName;
        @IgniteToStringInclude
        final Set<Replica> replicas = new HashSet<Replica>();

        NodeReplicas(String nodeName) {
            this.nodeName = nodeName;
        }

        boolean add(int partition, boolean isConsensusReplica) {
            if (!this.contains(partition)) {
                return this.replicas.add(new Replica(partition, isConsensusReplica));
            }
            return false;
        }

        void remove(int partition) {
            if (!this.replicas.remove(new Replica(partition, true))) {
                this.replicas.remove(new Replica(partition, false));
            }
        }

        boolean remove(Replica r) {
            return this.replicas.remove(r);
        }

        void flipConsensus(int partition) {
            Replica toAdd;
            Replica learner = new Replica(partition, false);
            Replica consensus = new Replica(partition, true);
            if (this.replicas.remove(learner)) {
                toAdd = consensus;
            } else if (this.replicas.remove(consensus)) {
                toAdd = learner;
            } else {
                throw new AssertionError((Object)String.format("Failed to flip replica role: not found [node=%s, partitionId=%d].", this.nodeName, partition));
            }
            if (!this.replicas.add(toAdd)) {
                throw new AssertionError((Object)String.format("Failed to flip replica to %s: failed to add partition that was removed [node=%s, partitionId=%d].", toAdd.isConsensusReplica ? "consensus" : "learner", this.nodeName, partition));
            }
        }

        int size() {
            return this.replicas.size();
        }

        boolean contains(int partition) {
            return this.replicas.contains(new Replica(partition, true)) || this.replicas.contains(new Replica(partition, false));
        }

        boolean contains(int partition, boolean isConsensusReplica) {
            return this.replicas.contains(new Replica(partition, isConsensusReplica));
        }

        @Override
        public int compareTo(NodeReplicas o) {
            return Integer.compare(this.size(), o.size());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeReplicas that = (NodeReplicas)o;
            return Objects.equals(this.replicas, that.replicas) && Objects.equals(this.nodeName, that.nodeName);
        }

        public int hashCode() {
            return Objects.hash(this.replicas, this.nodeName);
        }

        public String toString() {
            return S.toString(NodeReplicas.class, (Object)this);
        }
    }

    private static class Replica {
        final int partitionId;
        final boolean isConsensusReplica;

        Replica(int partitionId, boolean isConsensusReplica) {
            this.partitionId = partitionId;
            this.isConsensusReplica = isConsensusReplica;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Replica that = (Replica)o;
            return this.partitionId == that.partitionId && this.isConsensusReplica == that.isConsensusReplica;
        }

        public int hashCode() {
            return Objects.hash(this.partitionId, this.isConsensusReplica);
        }

        public String toString() {
            return IgniteStringFormatter.format((String)"replica [{}, {}]", (Object[])new Object[]{this.partitionId, this.isConsensusReplica ? "consensus" : "learner"});
        }
    }
}

