/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.partitiondistribution.DistributionAlgorithm;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class RendezvousDistributionFunction
implements DistributionAlgorithm {
    private static final IgniteLogger LOG = Loggers.forClass(RendezvousDistributionFunction.class);
    private static final Comparator<IgniteBiTuple<Long, String>> COMPARATOR = new HashComparator();
    public static final int MAX_PARTITIONS_COUNT = 65000;
    private static boolean exclNeighborsWarn;

    public static <T extends Collection<Assignment>> T assignPartition(int part, Collection<String> nodes, int replicas, int consensusGroupSize, Map<String, Collection<String>> neighborhoodCache, boolean exclNeighbors, @Nullable BiPredicate<String, T> nodeFilter, IntFunction<T> aggregator) {
        if (nodes.size() <= 1) {
            Collection res = (Collection)aggregator.apply(1);
            nodes.stream().map(Assignment::forPeer).forEach(res::add);
            return (T)res;
        }
        IgniteBiTuple[] hashArr = new IgniteBiTuple[nodes.size()];
        IgniteUtils.forEachIndexed(nodes, (node, i) -> {
            long hash = RendezvousDistributionFunction.hash(node.hashCode(), part);
            hashArr[i.intValue()] = new IgniteBiTuple((Object)hash, node);
        });
        int effectiveReplicas = replicas == Integer.MAX_VALUE ? nodes.size() : Math.min(replicas, nodes.size());
        LazyLinearSortedContainer sortedNodes = new LazyLinearSortedContainer(hashArr, effectiveReplicas);
        Iterator it = sortedNodes.iterator();
        Collection res = (Collection)aggregator.apply(effectiveReplicas);
        HashSet<String> allNeighbors = new HashSet<String>();
        String first = (String)it.next();
        res.add(Assignment.forPeer(first));
        if (exclNeighbors) {
            allNeighbors.addAll(neighborhoodCache.get(first));
        }
        if (replicas > 1) {
            int assignedConsensusReplicas = 1;
            while (it.hasNext() && res.size() < effectiveReplicas) {
                String node2 = (String)it.next();
                if (exclNeighbors) {
                    if (allNeighbors.contains(node2)) continue;
                    res.add(assignedConsensusReplicas++ < consensusGroupSize ? Assignment.forPeer(node2) : Assignment.forLearner(node2));
                    allNeighbors.addAll(neighborhoodCache.get(node2));
                    continue;
                }
                if (nodeFilter != null && !nodeFilter.test(node2, (String)((Object)res))) continue;
                res.add(assignedConsensusReplicas++ < consensusGroupSize ? Assignment.forPeer(node2) : Assignment.forLearner(node2));
            }
        }
        if (res.size() < effectiveReplicas && nodes.size() >= effectiveReplicas && exclNeighbors) {
            it = sortedNodes.iterator();
            it.next();
            while (it.hasNext() && res.size() < effectiveReplicas) {
                String node3 = (String)it.next();
                if (res.contains(node3)) continue;
                res.add(Assignment.forPeer(node3));
            }
            if (!exclNeighborsWarn) {
                LOG.warn("Distribution function excludeNeighbors property is ignored because topology has no enough nodes to assign all replicas.", new Object[0]);
                exclNeighborsWarn = true;
            }
        }
        assert (res.size() <= effectiveReplicas);
        return (T)res;
    }

    private static long hash(int key0, int key1) {
        long key = (long)key0 & 0xFFFFFFFFL | ((long)key1 & 0xFFFFFFFFL) << 32;
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >>> 24;
        key += (key << 3) + (key << 8);
        key ^= key >>> 14;
        key += (key << 2) + (key << 4);
        key ^= key >>> 28;
        key += key << 31;
        return key;
    }

    public static List<Set<Assignment>> assignPartitions(Collection<String> currentTopologySnapshot, int partitions, int replicas, int consensusGroupSize, boolean exclNeighbors, @Nullable BiPredicate<String, Set<Assignment>> nodeFilter) {
        return RendezvousDistributionFunction.assignPartitions(currentTopologySnapshot, partitions, replicas, consensusGroupSize, exclNeighbors, nodeFilter, HashSet::new);
    }

    public static <T extends Collection<Assignment>> List<T> assignPartitions(Collection<String> currentTopologySnapshot, int partitions, int replicas, int consensusGroupSize, boolean exclNeighbors, @Nullable BiPredicate<String, T> nodeFilter, IntFunction<T> aggregator) {
        assert (partitions <= 65000) : "partitions <= 65000 [partitions=" + partitions + "]";
        assert (partitions > 0) : "partitions > 0 [partitions=" + partitions + "]";
        assert (replicas > 0) : "replicas > 0 [replicas=" + replicas + "]";
        assert (consensusGroupSize <= replicas) : "consensusGroupSize must be less or equal to replicaFactor [consensusGroupSize=" + consensusGroupSize + ", replicas=" + replicas + "]";
        ArrayList<T> assignments = new ArrayList<T>(partitions);
        Map<String, Collection<String>> neighborhoodCache = exclNeighbors ? RendezvousDistributionFunction.neighbors(currentTopologySnapshot) : null;
        ArrayList<String> nodes = new ArrayList<String>(currentTopologySnapshot);
        for (int i = 0; i < partitions; ++i) {
            T partAssignment = RendezvousDistributionFunction.assignPartition(i, nodes, replicas, consensusGroupSize, neighborhoodCache, exclNeighbors, nodeFilter, aggregator);
            assignments.add(partAssignment);
        }
        return assignments;
    }

    @Override
    public List<Set<Assignment>> assignPartitions(Collection<String> nodes, List<Set<Assignment>> currentDistribution, int partitions, int replicaFactor, int consensusGroupSize) {
        return RendezvousDistributionFunction.assignPartitions(nodes, partitions, replicaFactor, consensusGroupSize, false, null);
    }

    public static Map<String, Collection<String>> neighbors(Collection<String> topSnapshot) {
        HashMap<String, HashSet<String>> macMap = new HashMap<String, HashSet<String>>(topSnapshot.size(), 1.0f);
        for (String node : topSnapshot) {
            String macs = String.valueOf(node.hashCode());
            HashSet<String> nodes = (HashSet<String>)macMap.get(macs);
            if (nodes == null) {
                nodes = new HashSet<String>();
                macMap.put(macs, nodes);
            }
            nodes.add(node);
        }
        HashMap<String, Collection<String>> neighbors = new HashMap<String, Collection<String>>(topSnapshot.size(), 1.0f);
        for (Collection group : macMap.values()) {
            for (String node : group) {
                neighbors.put(node, group);
            }
        }
        return neighbors;
    }

    public String toString() {
        return "U.toString(RendezvousDistributionFunction.class, this)";
    }

    public static int safeAbs(int i) {
        return (i = Math.abs(i)) < 0 ? 0 : i;
    }

    private static class LazyLinearSortedContainer
    implements Iterable<String> {
        private final IgniteBiTuple<Long, String>[] arr;
        private int sorted;

        LazyLinearSortedContainer(IgniteBiTuple<Long, String>[] arr, int needFirstSortedCnt) {
            this.arr = arr;
            if (needFirstSortedCnt > (int)Math.log(arr.length)) {
                Arrays.sort(arr, COMPARATOR);
                this.sorted = arr.length;
            }
        }

        @Override
        public Iterator<String> iterator() {
            return new SortIterator();
        }

        private class SortIterator
        implements Iterator<String> {
            private int cur;

            private SortIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.cur < LazyLinearSortedContainer.this.arr.length;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.cur < LazyLinearSortedContainer.this.sorted) {
                    return (String)LazyLinearSortedContainer.this.arr[this.cur++].get2();
                }
                IgniteBiTuple<Long, String> min = LazyLinearSortedContainer.this.arr[this.cur];
                int minIdx = this.cur;
                for (int i = this.cur + 1; i < LazyLinearSortedContainer.this.arr.length; ++i) {
                    if (COMPARATOR.compare(LazyLinearSortedContainer.this.arr[i], min) >= 0) continue;
                    minIdx = i;
                    min = LazyLinearSortedContainer.this.arr[i];
                }
                if (minIdx != this.cur) {
                    LazyLinearSortedContainer.this.arr[minIdx] = LazyLinearSortedContainer.this.arr[this.cur];
                    LazyLinearSortedContainer.this.arr[this.cur] = min;
                }
                LazyLinearSortedContainer.this.sorted = this.cur++;
                return (String)min.get2();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove doesn't supported");
            }
        }
    }

    private static class HashComparator
    implements Comparator<IgniteBiTuple<Long, String>>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private HashComparator() {
        }

        @Override
        public int compare(IgniteBiTuple<Long, String> o1, IgniteBiTuple<Long, String> o2) {
            return (Long)o1.get1() < (Long)o2.get1() ? -1 : ((Long)o1.get1() > (Long)o2.get1() ? 1 : ((String)o1.get2()).compareTo((String)o2.get2()));
        }
    }
}

