/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIoHeader;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.PageAllocationListener;
import org.apache.ignite.internal.pagememory.persistence.store.PageStore;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.jetbrains.annotations.Nullable;

public class FilePageStore
implements PageStore {
    private static final VarHandle PAGE_COUNT;
    private static final VarHandle NEW_DELTA_FILE_PAGE_STORE_IO_FUTURE;
    private static final VarHandle DELTA_FILE_PAGE_STORE_IOS;
    public static final int VERSION_1 = 1;
    public static final int DELTA_FILE_VERSION_1 = 1;
    public static final int LATEST_FILE_PAGE_STORE_VERSION = 1;
    public static final int LATEST_DELTA_FILE_PAGE_STORE_VERSION = 1;
    private final FilePageStoreIo filePageStoreIo;
    private volatile int pageCount;
    private volatile int checkpointedPageCount;
    @Nullable
    private volatile PageAllocationListener pageAllocationListener;
    private volatile List<DeltaFilePageStoreIo> deltaFilePageStoreIos;
    @Nullable
    private volatile CompletableFuture<DeltaFilePageStoreIo> newDeltaFilePageStoreIoFuture;
    private volatile boolean toDestroy;

    public FilePageStore(FilePageStoreIo filePageStoreIo, DeltaFilePageStoreIo ... deltaFilePageStoreIos) {
        if (deltaFilePageStoreIos.length > 0) {
            Arrays.sort(deltaFilePageStoreIos, Comparator.comparingInt(DeltaFilePageStoreIo::fileIndex).reversed());
        }
        this.filePageStoreIo = filePageStoreIo;
        this.deltaFilePageStoreIos = Arrays.asList(deltaFilePageStoreIos);
    }

    @Override
    public void stop(boolean clean) throws IgniteInternalCheckedException {
        this.filePageStoreIo.stop(clean);
        for (DeltaFilePageStoreIo deltaFilePageStoreIo : this.deltaFilePageStoreIos) {
            deltaFilePageStoreIo.stop(clean);
        }
    }

    @Override
    public int allocatePage() throws IgniteInternalCheckedException {
        this.ensure();
        int pageIdx = PAGE_COUNT.getAndAdd(this, 1);
        PageAllocationListener listener = this.pageAllocationListener;
        if (listener != null) {
            listener.onPageAllocated(pageIdx);
        }
        return pageIdx;
    }

    @Override
    public int pages() {
        return this.pageCount;
    }

    public void pages(int pageCount) {
        assert (pageCount >= 0) : pageCount;
        this.pageCount = pageCount;
        this.checkpointedPageCount = pageCount;
    }

    public int checkpointedPageCount() {
        return this.checkpointedPageCount;
    }

    public void checkpointedPageCount(int checkpointedPageCount) {
        assert (this.pageCount >= 0) : this.pageCount;
        this.checkpointedPageCount = checkpointedPageCount;
    }

    public void readWithoutPageIdCheck(long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteInternalCheckedException {
        for (DeltaFilePageStoreIo deltaFilePageStoreIo : this.deltaFilePageStoreIos) {
            long pageOff = deltaFilePageStoreIo.pageOffset(pageId);
            if (pageOff < 0L || !deltaFilePageStoreIo.readWithMergedToFilePageStoreCheck(pageId, pageOff, pageBuf, keepCrc)) continue;
            return;
        }
        this.filePageStoreIo.read(pageId, this.filePageStoreIo.pageOffset(pageId), pageBuf, keepCrc);
    }

    @Override
    public void read(long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteInternalCheckedException {
        assert (PageIdUtils.pageIndex(pageId) <= this.pageCount) : "pageIdx=" + PageIdUtils.pageIndex(pageId) + ", pageCount=" + this.pageCount;
        this.readWithoutPageIdCheck(pageId, pageBuf, keepCrc);
    }

    @Override
    public void write(long pageId, ByteBuffer pageBuf) throws IgniteInternalCheckedException {
        assert (PageIdUtils.pageIndex(pageId) <= this.pageCount) : "pageIdx=" + PageIdUtils.pageIndex(pageId) + ", pageCount=" + this.pageCount;
        this.filePageStoreIo.write(pageId, pageBuf);
    }

    @Override
    public void sync() throws IgniteInternalCheckedException {
        this.filePageStoreIo.sync();
    }

    @Override
    public boolean exists() {
        return this.filePageStoreIo.exists();
    }

    @Override
    public void ensure() throws IgniteInternalCheckedException {
        this.filePageStoreIo.ensure();
    }

    @Override
    public void close() throws IOException {
        this.filePageStoreIo.close();
        for (DeltaFilePageStoreIo deltaFilePageStoreIo : this.deltaFilePageStoreIos) {
            deltaFilePageStoreIo.close();
        }
    }

    public long size() throws IgniteInternalCheckedException {
        return this.filePageStoreIo.size();
    }

    public long fullSize() throws IgniteInternalCheckedException {
        long size = this.filePageStoreIo.size();
        for (DeltaFilePageStoreIo deltaFilePageStoreIo : this.deltaFilePageStoreIos) {
            size += deltaFilePageStoreIo.size();
        }
        return size;
    }

    public Path filePath() {
        return this.filePageStoreIo.filePath();
    }

    public int headerSize() {
        return this.filePageStoreIo.headerSize();
    }

    public void setPageAllocationListener(PageAllocationListener listener) {
        this.pageAllocationListener = listener;
    }

    public CompletableFuture<DeltaFilePageStoreIo> getOrCreateNewDeltaFile(IntFunction<Path> deltaFilePathFunction, Supplier<int[]> pageIndexesSupplier) {
        CompletableFuture<DeltaFilePageStoreIo> future = this.newDeltaFilePageStoreIoFuture;
        if (future != null) {
            return future;
        }
        future = new CompletableFuture();
        if (!NEW_DELTA_FILE_PAGE_STORE_IO_FUTURE.compareAndSet(this, null, future)) {
            return this.newDeltaFilePageStoreIoFuture;
        }
        DeltaFilePageStoreIo newDeltaFilePageStoreIo = this.addNewDeltaFilePageStoreIoToHead(pageIndexesSupplier.get(), deltaFilePathFunction);
        future.complete(newDeltaFilePageStoreIo);
        return future;
    }

    private DeltaFilePageStoreIo addNewDeltaFilePageStoreIoToHead(int[] pageIndexes, IntFunction<Path> deltaFilePathFunction) {
        DeltaFilePageStoreIo newDeltaFilePageStoreIo;
        List<DeltaFilePageStoreIo> newValue;
        List<DeltaFilePageStoreIo> previousValue;
        do {
            int nextIndex = (previousValue = this.deltaFilePageStoreIos).isEmpty() ? 0 : previousValue.get(0).fileIndex() + 1;
            DeltaFilePageStoreIoHeader header = new DeltaFilePageStoreIoHeader(1, nextIndex, this.filePageStoreIo.pageSize(), pageIndexes);
            newDeltaFilePageStoreIo = new DeltaFilePageStoreIo(this.filePageStoreIo.ioFactory, deltaFilePathFunction.apply(nextIndex), header);
            newValue = new ArrayList<DeltaFilePageStoreIo>(previousValue.size() + 1);
            newValue.add(newDeltaFilePageStoreIo);
            newValue.addAll(previousValue);
        } while (!DELTA_FILE_PAGE_STORE_IOS.compareAndSet(this, previousValue, newValue = Collections.unmodifiableList(newValue)));
        return newDeltaFilePageStoreIo;
    }

    @Nullable
    public CompletableFuture<DeltaFilePageStoreIo> getNewDeltaFile() {
        return this.newDeltaFilePageStoreIoFuture;
    }

    public void completeNewDeltaFile() {
        CompletableFuture<DeltaFilePageStoreIo> future = this.newDeltaFilePageStoreIoFuture;
        if (future == null) {
            return;
        }
        NEW_DELTA_FILE_PAGE_STORE_IO_FUTURE.compareAndSet(this, future, null);
    }

    public int deltaFileCount() {
        return this.deltaFilePageStoreIos.size();
    }

    @Nullable
    public DeltaFilePageStoreIo getDeltaFileToCompaction() {
        List<DeltaFilePageStoreIo> deltaFilePageStoreIos = this.deltaFilePageStoreIos;
        if (deltaFilePageStoreIos.isEmpty() || deltaFilePageStoreIos.size() == 1 && this.newDeltaFilePageStoreIoFuture != null) {
            return null;
        }
        return deltaFilePageStoreIos.get(deltaFilePageStoreIos.size() - 1);
    }

    public List<DeltaFilePageStoreIo> getCompletedDeltaFiles() {
        List<DeltaFilePageStoreIo> deltaFilePageStoreIos = this.deltaFilePageStoreIos;
        CompletableFuture<DeltaFilePageStoreIo> newDeltaFilePageStoreIoFuture = this.newDeltaFilePageStoreIoFuture;
        if (newDeltaFilePageStoreIoFuture != null && deltaFilePageStoreIos.contains(newDeltaFilePageStoreIoFuture.join())) {
            return deltaFilePageStoreIos.subList(1, deltaFilePageStoreIos.size());
        }
        return deltaFilePageStoreIos;
    }

    public boolean removeDeltaFile(DeltaFilePageStoreIo deltaFilePageStoreIo) {
        boolean removed;
        List<DeltaFilePageStoreIo> newValue;
        List<DeltaFilePageStoreIo> previousValue;
        do {
            previousValue = this.deltaFilePageStoreIos;
            newValue = new ArrayList<DeltaFilePageStoreIo>(previousValue);
            removed = newValue.remove(deltaFilePageStoreIo);
        } while (!DELTA_FILE_PAGE_STORE_IOS.compareAndSet(this, previousValue, newValue = Collections.unmodifiableList(newValue)));
        return removed;
    }

    public void markToDestroy() {
        this.toDestroy = true;
    }

    public boolean isMarkedToDestroy() {
        return this.toDestroy;
    }

    static {
        try {
            PAGE_COUNT = MethodHandles.lookup().findVarHandle(FilePageStore.class, "pageCount", Integer.TYPE);
            NEW_DELTA_FILE_PAGE_STORE_IO_FUTURE = MethodHandles.lookup().findVarHandle(FilePageStore.class, "newDeltaFilePageStoreIoFuture", CompletableFuture.class);
            DELTA_FILE_PAGE_STORE_IOS = MethodHandles.lookup().findVarHandle(FilePageStore.class, "deltaFilePageStoreIos", List.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

