/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.persistence.DirtyFullPageId;
import org.apache.ignite.internal.util.GridUnsafe;

public class PageHeader {
    static final long PAGE_MARKER = 1L;
    private static final int DIRTY_FLAG = 0x1000000;
    private static final int HEADER_IS_VALID_FLAG = 0x2000000;
    static final int UNKNOWN_PARTITION_GENERATION = -1;
    public static final int PAGE_OVERHEAD = 48;
    private static final int MARKER_OR_TIMESTAMP_OFFSET = 0;
    private static final int PARTITION_GENERATION_OFFSET = 8;
    private static final int FLAGS_OFFSET = 12;
    private static final int PAGE_ID_OFFSET = 16;
    private static final int PAGE_GROUP_ID_OFFSET = 24;
    private static final int PAGE_PIN_CNT_OFFSET = 28;
    public static final int PAGE_LOCK_OFFSET = 32;
    private static final int PAGE_TMP_BUF_OFFSET = 40;

    public static void initNew(long absPtr) {
        PageHeader.partitionGeneration(absPtr, -1);
        PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
        GridUnsafe.putLong((long)(absPtr + 0L), (long)1L);
        GridUnsafe.putInt((long)(absPtr + 28L), (int)0);
    }

    public static boolean dirty(long absPtr) {
        return PageHeader.flag(absPtr, 0x1000000, false);
    }

    public static boolean dirty(long absPtr, boolean dirty) {
        return PageHeader.flag(absPtr, 0x1000000, dirty, false);
    }

    public static boolean headerIsValid(long absPtr) {
        return PageHeader.flag(absPtr, 0x2000000, true);
    }

    public static void headerIsValid(long absPtr, boolean valid) {
        PageHeader.flag(absPtr, 0x2000000, valid, true);
    }

    private static boolean flag(long absPtr, int flagMask, boolean volatileAccess) {
        assert ((flagMask & 0xFFFFFF) == 0) : Integer.toHexString(flagMask);
        assert (Long.bitCount(flagMask) == 1) : Integer.toHexString(flagMask);
        int flags = volatileAccess ? GridUnsafe.getIntVolatile(null, (long)(absPtr + 12L)) : GridUnsafe.getInt((long)(absPtr + 12L));
        return (flags & flagMask) != 0;
    }

    private static boolean flag(long absPtr, int flagMask, boolean set, boolean volatileAccess) {
        boolean was;
        assert ((flagMask & 0xFFFFFF) == 0) : Integer.toHexString(flagMask);
        assert (Long.bitCount(flagMask) == 1) : Integer.toHexString(flagMask);
        int flags = volatileAccess ? GridUnsafe.getIntVolatile(null, (long)(absPtr + 12L)) : GridUnsafe.getInt((long)(absPtr + 12L));
        boolean bl = was = (flags & flagMask) != 0;
        flags = set ? (flags |= flagMask) : (flags &= ~flagMask);
        if (volatileAccess) {
            GridUnsafe.putIntVolatile(null, (long)(absPtr + 12L), (int)flags);
        } else {
            GridUnsafe.putInt((long)(absPtr + 12L), (int)flags);
        }
        return was;
    }

    public static boolean isAcquired(long absPtr) {
        return GridUnsafe.getInt((long)(absPtr + 28L)) > 0;
    }

    public static int acquirePage(long absPtr) {
        return GridUnsafe.incrementAndGetInt((long)(absPtr + 28L));
    }

    public static int releasePage(long absPtr) {
        return GridUnsafe.decrementAndGetInt((long)(absPtr + 28L));
    }

    static int pinCount(long absPtr) {
        return GridUnsafe.getIntVolatile(null, (long)(absPtr + 28L));
    }

    public static void timestamp(long absPtr, long timestamp) {
        GridUnsafe.putLongVolatile(null, (long)(absPtr + 0L), (long)((timestamp &= 0xFFFFFFFFFFFFFF00L) | 1L));
    }

    public static long timestamp(long absPtr) {
        long markerAndTs = GridUnsafe.getLong((long)(absPtr + 0L));
        return markerAndTs & 0xFFFFFFFFFFFFFF00L;
    }

    static void tempBufferPointer(long absPtr, long tmpRelPtr) {
        GridUnsafe.putLong((long)(absPtr + 40L), (long)tmpRelPtr);
    }

    static long tempBufferPointer(long absPtr) {
        return GridUnsafe.getLong((long)(absPtr + 40L));
    }

    static long pageId(long absPtr) {
        return GridUnsafe.getLong((long)(absPtr + 16L));
    }

    private static void pageId(long absPtr, long pageId) {
        GridUnsafe.putLong((long)(absPtr + 16L), (long)pageId);
    }

    private static int pageGroupId(long absPtr) {
        return GridUnsafe.getInt((long)(absPtr + 24L));
    }

    private static void pageGroupId(long absPtr, int grpId) {
        GridUnsafe.putInt((long)(absPtr + 24L), (int)grpId);
    }

    public static FullPageId fullPageId(long absPtr) {
        return new FullPageId(PageHeader.pageId(absPtr), PageHeader.pageGroupId(absPtr));
    }

    public static void fullPageId(long absPtr, FullPageId fullPageId) {
        PageHeader.pageId(absPtr, fullPageId.pageId());
        PageHeader.pageGroupId(absPtr, fullPageId.groupId());
    }

    public static int partitionGeneration(long absPtr) {
        return GridUnsafe.getInt((long)(absPtr + 8L));
    }

    static void partitionGeneration(long absPtr, int partitionGeneration) {
        assert (partitionGeneration > 0 || partitionGeneration == -1) : partitionGeneration;
        GridUnsafe.putInt((long)(absPtr + 8L), (int)partitionGeneration);
    }

    public static DirtyFullPageId dirtyFullPageId(long absPtr) {
        return new DirtyFullPageId(PageHeader.pageId(absPtr), PageHeader.pageGroupId(absPtr), PageHeader.partitionGeneration(absPtr));
    }

    public static void dirtyFullPageId(long absPtr, DirtyFullPageId dirtyFullPageId) {
        PageHeader.pageId(absPtr, dirtyFullPageId.pageId());
        PageHeader.pageGroupId(absPtr, dirtyFullPageId.groupId());
        PageHeader.partitionGeneration(absPtr, dirtyFullPageId.partitionGeneration());
    }
}

