/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.persistence.CheckpointUrgency;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointReadLockTimeoutException;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;

public class CheckpointTimeoutLock {
    protected static final IgniteLogger LOG = Loggers.forClass(CheckpointTimeoutLock.class);
    private final Supplier<CheckpointUrgency> urgencySupplier;
    private final CheckpointReadWriteLock checkpointReadWriteLock;
    private final Checkpointer checkpointer;
    private volatile long checkpointReadLockTimeout;
    private boolean stop;
    private final FailureManager failureManager;

    public CheckpointTimeoutLock(CheckpointReadWriteLock checkpointReadWriteLock, long checkpointReadLockTimeout, Supplier<CheckpointUrgency> urgencySupplier, Checkpointer checkpointer, FailureManager failureManager) {
        this.checkpointReadWriteLock = checkpointReadWriteLock;
        this.checkpointReadLockTimeout = checkpointReadLockTimeout;
        this.urgencySupplier = urgencySupplier;
        this.checkpointer = checkpointer;
        this.failureManager = failureManager;
    }

    public void start() {
        this.stop = false;
    }

    public void stop() {
        this.checkpointReadWriteLock.writeLock();
        try {
            this.stop = true;
        }
        finally {
            this.checkpointReadWriteLock.writeUnlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkpointReadLock() {
        if (this.checkpointReadWriteLock.isWriteLockHeldByCurrentThread()) {
            return;
        }
        long timeout = this.checkpointReadLockTimeout;
        long start = FastTimestamps.coarseCurrentTimeMillis();
        boolean interrupted = false;
        try {
            while (true) {
                CheckpointUrgency urgency;
                if (timeout > 0L && FastTimestamps.coarseCurrentTimeMillis() - start >= timeout) {
                    this.failCheckpointReadLock();
                }
                try {
                    if (timeout > 0L) {
                        if (!this.checkpointReadWriteLock.tryReadLock(timeout - (FastTimestamps.coarseCurrentTimeMillis() - start), TimeUnit.MILLISECONDS)) {
                            this.failCheckpointReadLock();
                        }
                    } else {
                        this.checkpointReadWriteLock.readLock();
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                if (this.stop) {
                    this.checkpointReadWriteLock.readUnlock();
                    throw new IgniteInternalException((Throwable)new NodeStoppingException("Failed to get checkpoint read lock"));
                }
                if (this.checkpointReadWriteLock.getReadHoldCount() > 1 || this.checkpointer.runner() == null || (urgency = this.urgencySupplier.get()) == CheckpointUrgency.NOT_REQUIRED) {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                CheckpointProgress checkpoint = this.checkpointer.scheduleCheckpoint(0L, "too many dirty pages");
                if (urgency != CheckpointUrgency.MUST_TRIGGER) {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
                try {
                    this.checkpointReadWriteLock.readUnlock();
                    long elapsed = FastTimestamps.coarseCurrentTimeMillis() - start;
                    if (timeout > 0L && elapsed >= timeout) {
                        this.failCheckpointReadLock();
                    }
                    try {
                        if (timeout > 0L) {
                            IgniteUtils.getUninterruptibly(checkpoint.futureFor(CheckpointState.LOCK_RELEASED), (long)(timeout - elapsed));
                            continue;
                        }
                        IgniteUtils.getUninterruptibly(checkpoint.futureFor(CheckpointState.LOCK_RELEASED));
                    }
                    catch (ExecutionException e) {
                        throw new IgniteInternalException("Failed to wait for checkpoint begin", e.getCause());
                    }
                    catch (CancellationException e) {
                        throw new IgniteInternalException("Failed to wait for checkpoint begin", (Throwable)e);
                    }
                    catch (TimeoutException e) {
                        this.failCheckpointReadLock();
                    }
                }
                catch (CheckpointReadLockTimeoutException e) {
                    LOG.debug(e.getMessage(), (Throwable)((Object)e));
                    timeout = 0L;
                }
            }
        }
        catch (Throwable throwable) {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    public boolean tryCheckpointReadLock() {
        return this.checkpointReadWriteLock.tryReadLock();
    }

    public void checkpointReadUnlock() {
        this.checkpointReadWriteLock.readUnlock();
    }

    public long checkpointReadLockTimeout() {
        return this.checkpointReadLockTimeout;
    }

    public void checkpointReadLockTimeout(long val) {
        this.checkpointReadLockTimeout = val;
    }

    public boolean checkpointLockIsHeldByThread() {
        return this.checkpointReadWriteLock.checkpointLockIsHeldByThread();
    }

    public boolean shouldReleaseReadLock() {
        return this.checkpointReadWriteLock.hasQueuedWriters();
    }

    private void failCheckpointReadLock() throws CheckpointReadLockTimeoutException {
        String msg = "Checkpoint read lock acquisition has been timed out.";
        IgniteInternalException e = new IgniteInternalException(ErrorGroups.CriticalWorkers.SYSTEM_CRITICAL_OPERATION_TIMEOUT_ERR, msg);
        if (this.failureManager.process(new FailureContext(FailureType.SYSTEM_CRITICAL_OPERATION_TIMEOUT, (Throwable)e))) {
            throw e;
        }
        throw new CheckpointReadLockTimeoutException(msg);
    }
}

