/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.IgniteThrottledLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.IgniteCheckpointThread;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.ReentrantReadWriteLockWithTracking;
import org.apache.ignite.internal.util.FastTimestamps;
import org.jetbrains.annotations.Nullable;

public class CheckpointReadWriteLock {
    static final String CHECKPOINT_RUNNER_THREAD_PREFIX = "checkpoint-runner";
    private static final long LONG_LOCK_THRESHOLD_MILLIS = 1000L;
    private static final String LONG_LOCK_THROTTLE_KEY = "long-lock";
    private final IgniteThrottledLogger log;
    private final ThreadLocal<Integer> checkpointReadLockHoldCount = ThreadLocal.withInitial(() -> 0);
    private final ReentrantReadWriteLockWithTracking checkpointLock;
    @Nullable
    private volatile Thread currentWriteLockHolder;

    public CheckpointReadWriteLock(ReentrantReadWriteLockWithTracking checkpointLock, Executor throttledLogExecutor) {
        this.checkpointLock = checkpointLock;
        this.log = Loggers.toThrottledLogger((IgniteLogger)Loggers.forClass(CheckpointReadWriteLock.class), (Executor)throttledLogExecutor);
    }

    public void readLock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return;
        }
        long start = FastTimestamps.coarseCurrentTimeMillis();
        this.checkpointLock.readLock().lock();
        this.onReadLock(start, true);
    }

    public boolean tryReadLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isWriteLockHeldByCurrentThread()) {
            return true;
        }
        long start = FastTimestamps.coarseCurrentTimeMillis();
        boolean res = this.checkpointLock.readLock().tryLock(timeout, unit);
        this.onReadLock(start, res);
        return res;
    }

    public boolean tryReadLock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return true;
        }
        long start = FastTimestamps.coarseCurrentTimeMillis();
        boolean res = this.checkpointLock.readLock().tryLock();
        this.onReadLock(start, res);
        return res;
    }

    public boolean checkpointLockIsHeldByThread() {
        return this.isWriteLockHeldByCurrentThread() || this.checkpointReadLockHoldCount.get() > 0 || Thread.currentThread() instanceof IgniteCheckpointThread;
    }

    public void readUnlock() {
        if (this.isWriteLockHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().unlock();
        this.checkpointReadLockHoldCount.set(this.checkpointReadLockHoldCount.get() - 1);
    }

    public void writeLock() {
        this.checkpointLock.writeLock().lock();
        this.currentWriteLockHolder = Thread.currentThread();
    }

    public void writeUnlock() {
        this.currentWriteLockHolder = null;
        this.checkpointLock.writeLock().unlock();
    }

    public boolean isWriteLockHeldByCurrentThread() {
        return this.currentWriteLockHolder == Thread.currentThread();
    }

    public int getReadHoldCount() {
        return this.checkpointLock.getReadHoldCount();
    }

    public boolean hasQueuedWriters() {
        return this.checkpointLock.hasQueuedWriters();
    }

    private void onReadLock(long start, boolean taken) {
        long elapsed = FastTimestamps.coarseCurrentTimeMillis() - start;
        if (taken) {
            this.checkpointReadLockHoldCount.set(this.checkpointReadLockHoldCount.get() + 1);
        }
        if (elapsed > 1000L) {
            this.log.warn(LONG_LOCK_THROTTLE_KEY, "Checkpoint read lock took {} ms to acquire.", new Object[]{elapsed});
        }
    }
}

