/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.Duration;
import org.apache.ignite.internal.util.FastTimestamps;

public class CheckpointMetricsTracker {
    private static final AtomicIntegerFieldUpdater<CheckpointMetricsTracker> DATA_PAGES_WRITTEN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CheckpointMetricsTracker.class, "dataPagesWritten");
    private static final AtomicIntegerFieldUpdater<CheckpointMetricsTracker> COPY_ON_WRITE_PAGES_WRITTEN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(CheckpointMetricsTracker.class, "copyOnWritePagesWritten");
    private volatile int dataPagesWritten;
    private volatile int copyOnWritePagesWritten;
    private final long startTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    private final Duration checkpointDuration = new Duration();
    private final Duration writeLockWaitDuration = new Duration();
    private final Duration onBeforeCheckpointBeginDuration = new Duration();
    private final Duration onMarkCheckpointBeginDuration = new Duration();
    private final Duration writeLockHoldDuration = new Duration();
    private final Duration pagesWriteDuration = new Duration();
    private final Duration fsyncDuration = new Duration();
    private final Duration replicatorLogSyncDuration = new Duration();
    private final Duration splitAndSortCheckpointPagesDuration = new Duration();
    private final Duration waitPageReplacement = new Duration();

    public void onCopyOnWritePageWritten() {
        COPY_ON_WRITE_PAGES_WRITTEN_UPDATER.incrementAndGet(this);
    }

    public int copyOnWritePagesWritten() {
        return this.copyOnWritePagesWritten;
    }

    public void onDataPageWritten() {
        DATA_PAGES_WRITTEN_UPDATER.incrementAndGet(this);
    }

    public int dataPagesWritten() {
        return this.dataPagesWritten;
    }

    public long checkpointStartTime() {
        return this.startTimestamp;
    }

    public void onCheckpointStart() {
        this.checkpointDuration.onStart();
    }

    public void onCheckpointEnd() {
        this.checkpointDuration.onEnd();
    }

    public long checkpointDuration(TimeUnit timeUnit) {
        return this.checkpointDuration.duration(timeUnit);
    }

    public void onWriteLockWaitStart() {
        this.writeLockWaitDuration.onStart();
    }

    public void onWriteLockWaitEnd() {
        this.writeLockWaitDuration.onEnd();
    }

    public long writeLockWaitDuration(TimeUnit timeUnit) {
        return this.writeLockWaitDuration.duration(timeUnit);
    }

    public void onBeforeCheckpointBeginStart() {
        this.onBeforeCheckpointBeginDuration.onStart();
    }

    public void onBeforeCheckpointBeginEnd() {
        this.onBeforeCheckpointBeginDuration.onEnd();
    }

    public long onBeforeCheckpointBeginDuration(TimeUnit timeUnit) {
        return this.onBeforeCheckpointBeginDuration.duration(timeUnit);
    }

    public void onMarkCheckpointBeginStart() {
        this.onMarkCheckpointBeginDuration.onStart();
    }

    public void onMarkCheckpointBeginEnd() {
        this.onMarkCheckpointBeginDuration.onEnd();
    }

    public long onMarkCheckpointBeginDuration(TimeUnit timeUnit) {
        return this.onMarkCheckpointBeginDuration.duration(timeUnit);
    }

    public void onPagesWriteStart() {
        this.pagesWriteDuration.onStart();
    }

    public void onPagesWriteEnd() {
        this.pagesWriteDuration.onEnd();
    }

    public long pagesWriteDuration(TimeUnit timeUnit) {
        return this.pagesWriteDuration.duration(timeUnit);
    }

    public void onFsyncStart() {
        this.fsyncDuration.onStart();
    }

    public void onFsyncEnd() {
        this.fsyncDuration.onEnd();
    }

    public long fsyncDuration(TimeUnit timeUnit) {
        return this.fsyncDuration.duration(timeUnit);
    }

    public void onSplitAndSortCheckpointPagesStart() {
        this.splitAndSortCheckpointPagesDuration.onStart();
    }

    public void onSplitAndSortCheckpointPagesEnd() {
        this.splitAndSortCheckpointPagesDuration.onEnd();
    }

    public long splitAndSortCheckpointPagesDuration(TimeUnit timeUnit) {
        return this.splitAndSortCheckpointPagesDuration.duration(timeUnit);
    }

    public void onReplicatorLogSyncStart() {
        this.replicatorLogSyncDuration.onStart();
    }

    public void onReplicatorLogSyncEnd() {
        this.replicatorLogSyncDuration.onEnd();
    }

    public long replicatorLogSyncDuration(TimeUnit timeUnit) {
        return this.replicatorLogSyncDuration.duration(timeUnit);
    }

    public void onWriteLockHoldStart() {
        this.writeLockHoldDuration.onStart();
    }

    public void onWriteLockHoldEnd() {
        this.writeLockHoldDuration.onEnd();
    }

    public long writeLockHoldDuration(TimeUnit timeUnit) {
        return this.writeLockHoldDuration.duration(timeUnit);
    }

    public long beforeWriteLockDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.writeLockWaitDuration.startNanos() - this.checkpointDuration.startNanos(), TimeUnit.NANOSECONDS);
    }

    public void onWaitPageReplacementStart() {
        this.waitPageReplacement.onStart();
    }

    public void onWaitPageReplacementEnd() {
        this.waitPageReplacement.onEnd();
    }

    public long waitPageReplacementDuration(TimeUnit timeUnit) {
        return this.waitPageReplacement.duration(timeUnit);
    }
}

