/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.io;

import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.tostring.S;

public class DataPagePayload {
    private final int off;
    private final int payloadSize;
    private final long nextLink;

    public DataPagePayload(int off, int payloadSize, long nextLink) {
        this.off = off;
        this.payloadSize = payloadSize;
        this.nextLink = nextLink;
    }

    public int offset() {
        return this.off;
    }

    public int payloadSize() {
        return this.payloadSize;
    }

    public long nextLink() {
        return this.nextLink;
    }

    public boolean hasMoreFragments() {
        return this.nextLink != 0L;
    }

    public byte[] getBytes(long pageAddr) {
        return PageUtils.getBytes(pageAddr, this.off, this.payloadSize);
    }

    public String toString() {
        return S.toString(DataPagePayload.class, (Object)this);
    }
}

