/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.compaction;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PartitionDestructionLockManager;
import org.apache.ignite.internal.pagememory.persistence.WriteSpeedFormatter;
import org.apache.ignite.internal.pagememory.persistence.compaction.CompactionMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.pagememory.persistence.store.GroupPageStoresMap;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.jetbrains.annotations.Nullable;

public class Compactor
extends IgniteWorker {
    private static final IgniteLogger LOG = Loggers.forClass(Compactor.class);
    private final Object mux = new Object();
    @Nullable
    private final ThreadPoolExecutor threadPoolExecutor;
    private boolean addedDeltaFiles;
    private final FilePageStoreManager filePageStoreManager;
    private static final ThreadLocal<ByteBuffer> THREAD_BUF = new ThreadLocal();
    private final int pageSize;
    private final FailureManager failureManager;
    private final PartitionDestructionLockManager partitionDestructionLockManager;
    private boolean paused;

    public Compactor(IgniteLogger log, String igniteInstanceName, int threads, FilePageStoreManager filePageStoreManager, int pageSize, FailureManager failureManager, PartitionDestructionLockManager partitionDestructionLockManager) {
        super(log, igniteInstanceName, "compaction-thread");
        this.filePageStoreManager = filePageStoreManager;
        this.failureManager = failureManager;
        this.partitionDestructionLockManager = partitionDestructionLockManager;
        if (threads > 1) {
            this.threadPoolExecutor = new ThreadPoolExecutor(threads, threads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)IgniteThreadFactory.create((String)igniteInstanceName, (String)"compaction-runner-io", (IgniteLogger)log, (ThreadOperation[])new ThreadOperation[0]));
            this.threadPoolExecutor.allowCoreThreadTimeOut(true);
        } else {
            this.threadPoolExecutor = null;
        }
        this.pageSize = pageSize;
    }

    protected void body() throws InterruptedException {
        try {
            while (!this.isCancelled()) {
                this.waitDeltaFiles();
                if (this.isCancelled()) {
                    this.log.info("Skipping the delta file compaction because the node is stopping", new Object[0]);
                    return;
                }
                this.doCompaction();
            }
        }
        catch (Throwable t) {
            this.failureManager.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, t));
            throw new IgniteInternalException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitDeltaFiles() {
        try {
            Object object = this.mux;
            synchronized (object) {
                while (!(this.addedDeltaFiles && !this.paused || this.isCancelled())) {
                    this.blockingSectionBegin();
                    try {
                        this.mux.wait();
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
                this.addedDeltaFiles = false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.isCancelled.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerCompaction() {
        Object object = this.mux;
        synchronized (object) {
            this.addedDeltaFiles = true;
            this.mux.notifyAll();
        }
    }

    void doCompaction() {
        Queue queue;
        while (!this.isPaused() && !(queue = (Queue)this.filePageStoreManager.allPageStores().map(groupPartitionFilePageStore -> {
            DeltaFilePageStoreIo deltaFileToCompaction = ((FilePageStore)groupPartitionFilePageStore.pageStore()).getDeltaFileToCompaction();
            if (deltaFileToCompaction == null) {
                return null;
            }
            return new DeltaFileForCompaction((GroupPageStoresMap.GroupPartitionPageStore<FilePageStore>)groupPartitionFilePageStore, deltaFileToCompaction);
        }).filter(Objects::nonNull).collect(Collectors.toCollection(ConcurrentLinkedQueue::new))).isEmpty()) {
            String compactionId = UUID.randomUUID().toString();
            if (LOG.isInfoEnabled()) {
                LOG.info("Starting new compaction round [compactionId={}, files={}]", new Object[]{compactionId, queue.size()});
            }
            CompactionMetricsTracker tracker = new CompactionMetricsTracker();
            this.updateHeartbeat();
            int threads = this.threadPoolExecutor == null ? 1 : this.threadPoolExecutor.getMaximumPoolSize();
            CompletableFuture[] futures = new CompletableFuture[threads];
            for (int i = 0; i < threads; ++i) {
                CompletableFuture future = futures[i] = new CompletableFuture();
                Runnable merger = () -> {
                    try {
                        DeltaFileForCompaction toMerge;
                        while ((toMerge = (DeltaFileForCompaction)queue.poll()) != null) {
                            GroupPartitionId groupPartitionId = toMerge.groupPartitionFilePageStore.groupPartitionId();
                            Lock partitionDestructionLock = this.partitionDestructionLockManager.destructionLock(groupPartitionId).readLock();
                            partitionDestructionLock.lock();
                            try {
                                this.mergeDeltaFileToMainFile(toMerge.groupPartitionFilePageStore.pageStore(), toMerge.deltaFilePageStoreIo, tracker);
                            }
                            finally {
                                partitionDestructionLock.unlock();
                            }
                        }
                    }
                    catch (Throwable ex) {
                        future.completeExceptionally(ex);
                    }
                    future.complete(null);
                };
                if (this.isCancelled()) {
                    return;
                }
                if (this.threadPoolExecutor == null) {
                    merger.run();
                    continue;
                }
                this.threadPoolExecutor.execute(merger);
            }
            this.updateHeartbeat();
            CompletableFuture.allOf(futures).join();
            tracker.onCompactionEnd();
            if (!LOG.isInfoEnabled()) continue;
            long totalWriteBytes = (long)this.pageSize * (long)tracker.dataPagesWritten();
            long totalDurationInNanos = tracker.totalDuration(TimeUnit.NANOSECONDS);
            LOG.info("Compaction round finished [compactionId={}, pages={}, duration={}ms, avgWriteSpeed={}MB/s]", new Object[]{compactionId, tracker.dataPagesWritten(), tracker.totalDuration(TimeUnit.MILLISECONDS), WriteSpeedFormatter.formatWriteSpeed(totalWriteBytes, totalDurationInNanos)});
        }
    }

    public void start() {
        if (this.runner() != null) {
            return;
        }
        assert (this.runner() == null) : "Compacter is running";
        new IgniteThread((IgniteWorker)this).start();
    }

    public void stop() throws Exception {
        this.cancel();
        boolean interrupt = false;
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                interrupt = true;
                continue;
            }
            break;
        }
        if (interrupt) {
            Thread.currentThread().interrupt();
        }
        if (this.threadPoolExecutor != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPoolExecutor, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancelling grid runnable: " + this, new Object[0]);
        }
        Object object = this.mux;
        synchronized (object) {
            this.paused = false;
            this.isCancelled.set(true);
            this.mux.notifyAll();
        }
    }

    void mergeDeltaFileToMainFile(FilePageStore filePageStore, DeltaFilePageStoreIo deltaFilePageStore, CompactionMetricsTracker tracker) throws Throwable {
        ByteBuffer buffer = Compactor.getThreadLocalBuffer(this.pageSize);
        int[] nArray = deltaFilePageStore.pageIndexes();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long pageIndex = nArray[i];
            this.updateHeartbeat();
            if (this.shouldStopCompaction(filePageStore)) {
                return;
            }
            long pageOffset = deltaFilePageStore.pageOffset(pageIndex);
            boolean read = deltaFilePageStore.readWithMergedToFilePageStoreCheck(pageIndex, pageOffset, buffer.rewind(), false);
            assert (read) : deltaFilePageStore.filePath();
            long pageId = PageIo.getPageId(buffer.rewind());
            assert (pageId != 0L) : "Page with index " + pageIndex + " at offset " + pageOffset + " has unexpected 0 pageId in file " + deltaFilePageStore.filePath() + ". Page content: " + StringUtils.toHexString((ByteBuffer)buffer);
            this.updateHeartbeat();
            if (this.shouldStopCompaction(filePageStore)) {
                return;
            }
            filePageStore.write(pageId, buffer.rewind());
            tracker.onDataPageWritten();
        }
        this.updateHeartbeat();
        if (this.shouldStopCompaction(filePageStore)) {
            return;
        }
        filePageStore.sync();
        this.updateHeartbeat();
        if (this.shouldStopCompaction(filePageStore)) {
            return;
        }
        deltaFilePageStore.markMergedToFilePageStore();
        deltaFilePageStore.stop(true);
        boolean removed = filePageStore.removeDeltaFile(deltaFilePageStore);
        assert (removed) : filePageStore.filePath();
    }

    private static ByteBuffer getThreadLocalBuffer(int pageSize) {
        ByteBuffer buffer = THREAD_BUF.get();
        if (buffer == null) {
            buffer = ByteBuffer.allocateDirect(pageSize);
            buffer.order(ByteOrder.nativeOrder());
            THREAD_BUF.set(buffer);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.mux;
        synchronized (object) {
            assert (!this.paused) : "It is expected that a further pause will only occur after resume";
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.mux;
        synchronized (object) {
            this.paused = false;
            this.addedDeltaFiles = true;
            this.mux.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPaused() {
        Object object = this.mux;
        synchronized (object) {
            return this.paused;
        }
    }

    private boolean shouldStopCompaction(FilePageStore filePageStore) {
        return this.isCancelled() || filePageStore.isMarkedToDestroy() || this.isPaused();
    }

    private static class DeltaFileForCompaction {
        private final GroupPageStoresMap.GroupPartitionPageStore<FilePageStore> groupPartitionFilePageStore;
        private final DeltaFilePageStoreIo deltaFilePageStoreIo;

        private DeltaFileForCompaction(GroupPageStoresMap.GroupPartitionPageStore<FilePageStore> groupPartitionFilePageStore, DeltaFilePageStoreIo deltaFilePageStoreIo) {
            this.groupPartitionFilePageStore = groupPartitionFilePageStore;
            this.deltaFilePageStoreIo = deltaFilePageStoreIo;
        }
    }
}

