/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.util.FastTimestamps;

public class ReentrantReadWriteLockWithTracking
implements ReadWriteLock {
    private final ReentrantReadWriteLock delegate = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock.WriteLock(this.delegate){};

    public ReentrantReadWriteLockWithTracking(IgniteLogger log, long readLockThreshold) {
        this.readLock = new ReadLockWithTracking(this.delegate, log, readLockThreshold);
    }

    public ReentrantReadWriteLockWithTracking() {
        this.readLock = new ReentrantReadWriteLock.ReadLock(this.delegate){};
    }

    @Override
    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLock;
    }

    @Override
    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLock;
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.delegate.isWriteLockedByCurrentThread();
    }

    public int getReadHoldCount() {
        return this.delegate.getReadHoldCount();
    }

    public int getReadLockCount() {
        return this.delegate.getReadLockCount();
    }

    public boolean hasQueuedWriters() {
        return this.delegate.hasQueuedThreads();
    }

    private static class ReadLockWithTracking
    extends ReentrantReadWriteLock.ReadLock {
        private static final long serialVersionUID = 0L;
        private final ThreadLocal<IgniteBiTuple<Integer, Long>> readLockHolderTs = ThreadLocal.withInitial(() -> new IgniteBiTuple((Object)0, (Object)0L));
        private final IgniteLogger log;
        private final long readLockThreshold;

        protected ReadLockWithTracking(ReentrantReadWriteLock lock, IgniteLogger log, long readLockThreshold) {
            super(lock);
            this.log = log;
            this.readLockThreshold = readLockThreshold;
        }

        private void inc() {
            IgniteBiTuple<Integer, Long> val = this.readLockHolderTs.get();
            int cntr = (Integer)val.get1();
            if (cntr == 0) {
                val.set2((Object)FastTimestamps.coarseCurrentTimeMillis());
            }
            val.set1((Object)(++cntr));
            this.readLockHolderTs.set(val);
        }

        private void dec() {
            long timeout;
            IgniteBiTuple<Integer, Long> val = this.readLockHolderTs.get();
            int cntr = (Integer)val.get1();
            if (--cntr == 0 && (timeout = FastTimestamps.coarseCurrentTimeMillis() - (Long)val.get2()) > this.readLockThreshold) {
                this.log.warn("ReadLock held for too long [heldFor={}ms]", (Throwable)new IgniteInternalException(), new Object[]{timeout});
            }
            val.set1((Object)cntr);
            this.readLockHolderTs.set(val);
        }

        @Override
        public void lock() {
            super.lock();
            this.inc();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            super.lockInterruptibly();
            this.inc();
        }

        @Override
        public boolean tryLock() {
            if (super.tryLock()) {
                this.inc();
                return true;
            }
            return false;
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (super.tryLock(timeout, unit)) {
                this.inc();
                return true;
            }
            return false;
        }

        @Override
        public void unlock() {
            super.unlock();
            this.dec();
        }
    }
}

