/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.throttling;

import java.util.concurrent.atomic.AtomicInteger;

class ExponentialBackoff {
    private final long startingBackoffNanos;
    private final double backoffRatio;
    private final AtomicInteger exponentialBackoffCounter = new AtomicInteger(0);

    public ExponentialBackoff(long startingBackoffNanos, double backoffRatio) {
        this.startingBackoffNanos = startingBackoffNanos;
        this.backoffRatio = backoffRatio;
    }

    public long nextDuration() {
        int exponent = this.exponentialBackoffCounter.getAndIncrement();
        return (long)((double)this.startingBackoffNanos * Math.pow(this.backoffRatio, exponent));
    }

    public boolean reset() {
        int oldValue = this.exponentialBackoffCounter.getAndSet(0);
        return oldValue != 0;
    }
}

