/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.apache.ignite.internal.fileio.FileIo;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.persistence.store.AbstractFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreHeader;
import org.apache.ignite.internal.pagememory.persistence.store.PageStoreUtils;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;

public class FilePageStoreIo
extends AbstractFilePageStoreIo {
    private final FilePageStoreHeader header;

    public FilePageStoreIo(FileIoFactory ioFactory, Path filePath, FilePageStoreHeader header) {
        super(ioFactory, filePath);
        this.header = header;
    }

    @Override
    public int pageSize() {
        return this.header.pageSize();
    }

    @Override
    public int headerSize() {
        return this.header.headerSize();
    }

    @Override
    public ByteBuffer headerBuffer() {
        return this.header.toByteBuffer();
    }

    @Override
    public void checkHeader(FileIo fileIo) throws IOException {
        FilePageStoreHeader header = FilePageStoreHeader.readHeader(fileIo, ByteBuffer.allocate(this.pageSize()).order(ByteOrder.nativeOrder()));
        if (header == null) {
            throw new IOException("Missing file header");
        }
        PageStoreUtils.checkFileVersion(this.header.version(), header.version());
        PageStoreUtils.checkFilePageSize(this.header.pageSize(), header.pageSize());
    }

    @Override
    public void read(long pageId, long pageOff, ByteBuffer pageBuf, boolean keepCrc) throws IgniteInternalCheckedException {
        super.read(pageId, pageOff, pageBuf, keepCrc);
    }

    @Override
    public long pageOffset(long pageId) {
        return (long)PageIdUtils.pageIndex(pageId) * (long)this.pageSize() + (long)this.headerSize();
    }
}

